/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.PageData;
import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.WikiHelpWindow;
import com.wiki.standalone.moxkiriya.WikiRepository;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLAnchorElement;

public class WikiHelpWindowController
implements Initializable {
    private WikiHelpWindow wikiHelpWindow_;
    @FXML
    private Button buttonClose;
    @FXML
    private Hyperlink hyperlinkSidemenuHelpTOC;
    @FXML
    private WebView webViewSidemenu;
    @FXML
    private WebView webViewMain;
    private WikiEngine helpMainWikiEngine_;
    private HashMap<String, PageData> pageMap_;
    private static final String KEY_HELP_TOC_TITLE = "key.Help.TOC";
    private String HelpTOCTitle;
    private PageData helpTOCPageData_ = null;

    @Override
    public void initialize(URL url, ResourceBundle resource) {
        try {
            this.helpMainWikiEngine_ = new WikiEngine();
            this.HelpTOCTitle = resource.getString(KEY_HELP_TOC_TITLE);
            this.setLinkClickListner(this.webViewMain.getEngine());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setWikiHelpWindow(WikiHelpWindow helpWindow) {
        this.wikiHelpWindow_ = helpWindow;
    }

    public void setWikiRepository(WikiRepository wikiRepository) {
        this.helpMainWikiEngine_.setWikiRepository(wikiRepository);
    }

    @FXML
    public void onActionButtonClose(ActionEvent event) {
        ((Node)event.getSource()).getScene().getWindow().hide();
    }

    @FXML
    public void onMouseClickedSidemenuHyperlinkHelpTOC() {
        try {
            this.loadTableOfContent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadTableOfContent() throws Exception {
        if (this.helpTOCPageData_ == null) {
            this.pageMap_ = this.helpMainWikiEngine_.queryPageNamespace("Help");
            for (PageData node : this.pageMap_.values()) {
                if (!node.getTitle().equals(this.HelpTOCTitle)) continue;
                this.helpTOCPageData_ = node;
                break;
            }
        }
        if (this.helpTOCPageData_ != null) {
            String content = this.helpMainWikiEngine_.parse(this.helpTOCPageData_);
            this.webViewMain.getEngine().loadContent(content);
        }
    }

    private void setLinkClickListner(WebEngine webEngine) {
        webEngine.getLoadWorker().stateProperty().addListener(new ChangeListener<Worker.State>(){

            @Override
            public void changed(ObservableValue<? extends Worker.State> arg0, Worker.State oldState, Worker.State newState) {
                WebView webView = WikiHelpWindowController.this.webViewMain;
                EventListener listener = new EventListener(){

                    @Override
                    public void handleEvent(Event event) {
                        try {
                            MouseEvent mouseEvent = (MouseEvent)event;
                            EventTarget target = mouseEvent.getCurrentTarget();
                            if (this.isExternalLink(target)) {
                                event.preventDefault();
                            } else {
                                this.internalLinkHandle(target);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    private boolean isExternalLink(EventTarget target) {
                        ArrayList<String> schemeList = new ArrayList<String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.add("http://");
                                this.add("https://");
                                this.add("file://");
                            }
                        };
                        HTMLAnchorElement aElem = (HTMLAnchorElement)((Object)target);
                        String href = aElem.getAttribute("href");
                        boolean isExternal = false;
                        for (String scheme : schemeList) {
                            if (!href.startsWith(scheme)) continue;
                            isExternal = true;
                            break;
                        }
                        return isExternal;
                    }

                    private void internalLinkHandle(EventTarget target) throws Exception {
                        PageData pageData;
                        HTMLAnchorElement anchor = (HTMLAnchorElement)((Object)target);
                        String href = anchor.getAttribute("href");
                        String pageTitle = URLDecoder.decode(href, "UTF-8");
                        String uuid = anchor.getAttribute("data-jcr_uuid");
                        HashMap<String, PageData> pageDataMap = uuid != null ? WikiHelpWindowController.this.helpMainWikiEngine_.queryPageUUID(uuid) : WikiHelpWindowController.this.helpMainWikiEngine_.queryPageTitle(pageTitle);
                        if (pageDataMap.size() == 1 && (pageData = pageDataMap.values().iterator().next()).getNamespace().equals("Help")) {
                            String content = WikiHelpWindowController.this.helpMainWikiEngine_.parse(pageData);
                            WikiHelpWindowController.this.webViewMain.getEngine().loadContent(content);
                        }
                    }
                };
                if (newState == Worker.State.SUCCEEDED) {
                    Document doc = webView.getEngine().getDocument();
                    NodeList listA = doc.getElementsByTagName("a");
                    int index = 0;
                    while (index < listA.getLength()) {
                        ((EventTarget)((Object)listA.item(index))).addEventListener("click", listener, false);
                        ++index;
                    }
                }
            }
        });
    }
}

