/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.SettingManager;
import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.WikiMainWindowController;
import com.wiki.standalone.moxkiriya.util.FileIO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class WikiMainWindow {
    private Stage primaryStage_ = null;
    private ResourceBundle resources_ = null;
    private SettingManager settingManager_ = null;
    private WikiEngine wikiEngine_;
    private WikiMainWindowController controller_;

    public WikiMainWindow(Stage primaryStage, ResourceBundle resources) {
        this.primaryStage_ = primaryStage;
        this.resources_ = resources;
        this.settingManager_ = SettingManager.getInstance();
    }

    public CloseType show() throws Exception {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("WikiMainWindow.fxml"), this.resources_);
            loader.load();
            this.controller_ = (WikiMainWindowController)loader.getController();
            this.controller_.setWikiEngine(this.wikiEngine_);
            Scene scene = new Scene((Parent)loader.getRoot());
            scene.getStylesheets().add(this.getClass().getResource("application.css").toExternalForm());
            this.wikiEngine_.setPageDataMap("MainPage");
            this.controller_.loadWikiContent();
            Stage stage = new Stage(StageStyle.DECORATED);
            stage.initOwner(this.primaryStage_);
            this.controller_.setStage(stage);
            stage.setScene(scene);
            stage.setTitle(this.resources_.getString("key.Application.Title"));
            stage.showAndWait();
            this.controller_.hidePreviewWindow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.controller_.getCloseType();
    }

    public void buildWikiMainTree(File wikirootPath) throws Exception {
        this.createCssFiles();
        this.uploadResourcefile(this.settingManager_.getAbsolutePath("fixedstylesheet.css"), "fixedstylesheet.css");
        this.uploadResourcefile(this.settingManager_.getAbsolutePath("defaultstylesheet.css"), "defaultstylesheet.css");
        this.createRepositoryConfig();
        this.wikiEngine_ = new WikiEngine();
        this.wikiEngine_.buildWikiRepository(wikirootPath);
    }

    public void uploadResourcefile(String absolutePath, String filename) throws IOException {
        File destFile = new File(absolutePath);
        if (!destFile.exists()) {
            InputStream in = this.getClass().getResourceAsStream("resources/" + filename);
            Path destPath = Paths.get(absolutePath, new String[0]);
            Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
            Files.copy(in, destPath, new CopyOption[0]);
        }
    }

    private void createRepositoryConfig() throws Exception {
        SettingManager settingMgr = SettingManager.getInstance();
        String path = settingMgr.get("MOXKIRIYA_USER_DIR");
        String configXML = settingMgr.get("clustersetting").equals("true") ? "repository_cluster_derby.xml" : "repository_local.xml";
        File file = new File(String.valueOf(path) + "/" + settingMgr.getSelectedParty() + "/" + configXML);
        if (!file.exists()) {
            String line;
            InputStream inputStream = this.getClass().getResourceAsStream("resources/" + configXML);
            InputStreamReader streamReader = new InputStreamReader(inputStream, "UTF-8");
            BufferedReader reader = new BufferedReader(streamReader);
            StringBuffer buf = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buf.append(String.valueOf(line) + "\n");
            }
            reader.close();
            file.createNewFile();
            BufferedWriter writer = FileIO.bufferedWriter(file);
            writer.write(buf.toString());
            writer.flush();
            writer.close();
        }
    }

    private void createCssFiles() throws Exception {
        SettingManager settingMgr = SettingManager.getInstance();
        String templateHtmlHeaderPath = settingMgr.getAbsolutePath("templateHtmlHead.txt");
        if (!new File(templateHtmlHeaderPath).exists()) {
            InputStream in = this.getClass().getResourceAsStream("resources/templateHtmlHead.txt");
            Path destPath = Paths.get(templateHtmlHeaderPath, new String[0]);
            Files.copy(in, destPath, new CopyOption[0]);
        }
    }

    public void closeSession() {
        this.wikiEngine_.closeSession();
    }

    public static enum CloseType {
        EXIT,
        RESTART;

    }
}

