/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.PageData;
import com.wiki.standalone.moxkiriya.WikiMainWindowController;
import com.wiki.standalone.moxkiriya.WikiPreviewWindowController;
import com.wiki.standalone.moxkiriya.WikiRepository;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class WikiPreviewWindow {
    private Stage motherStage_ = null;
    private ResourceBundle resources_ = null;
    private Stage stage_;
    private WikiPreviewWindowController controller_;
    private WikiMainWindowController mainController_;
    private PreviewWindowStatus previewWindowStatus_ = PreviewWindowStatus.HIDE;

    public WikiPreviewWindow(Stage motherStage, ResourceBundle resources) {
        this.motherStage_ = motherStage;
        this.resources_ = resources;
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("WikiPreviewWindow.fxml"), this.resources_);
            loader.load();
            Scene scene = new Scene((Parent)loader.getRoot());
            scene.getStylesheets().add(this.getClass().getResource("application.css").toExternalForm());
            this.controller_ = (WikiPreviewWindowController)loader.getController();
            this.controller_.setWikiPreviewWindow(this);
            this.stage_ = new Stage(StageStyle.DECORATED);
            this.stage_.initOwner(this.motherStage_);
            this.stage_.setScene(scene);
            this.stage_.setTitle(this.resources_.getString("key.PreviewWindow.Title"));
            this.stage_.setResizable(true);
            this.stage_.showingProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    WikiPreviewWindow.this.previewWindowStatus_ = newValue == false ? PreviewWindowStatus.HIDE : PreviewWindowStatus.SHOW;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMainWindowController(WikiMainWindowController mainController) {
        this.mainController_ = mainController;
    }

    public void setWikiRepository(WikiRepository wikiRepository) {
        this.controller_.setWikiRepository(wikiRepository);
    }

    public PageData getLatestContents() throws Exception {
        return this.mainController_.getLatestContents();
    }

    public void show() throws Exception {
        this.controller_.loadWikiContent(this.mainController_.getLatestContents());
        if (this.previewWindowStatus_ == PreviewWindowStatus.HIDE) {
            this.stage_.show();
        } else {
            this.controller_.loadWikiContent(this.mainController_.getLatestContents());
        }
    }

    public void hide() {
        this.stage_.hide();
    }

    private static enum PreviewWindowStatus {
        SHOW,
        HIDE;

    }
}

