/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.dialog;

import com.wiki.standalone.moxkiriya.SettingManager;
import com.wiki.standalone.moxkiriya.dialog.DialogControllerBase;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;

public class ConfigSettingsDialogController
extends DialogControllerBase {
    @FXML
    private TextField textFieldPartyName;
    @FXML
    private CheckBox checkBoxDefaultParty;
    @FXML
    private TextField textFieldApproot;
    @FXML
    private Button buttonChooseDirectory;
    @FXML
    private CheckBox checkBoxClusterSetting;
    @FXML
    private TextField textFieldDBServerURL;
    @FXML
    private TextField textFieldPortNumber;
    @FXML
    private TextField textFieldJDBCDriver;
    @FXML
    private Button buttonOK;
    private Window parentWindow_;
    private String partyName_;
    private Hashtable<String, String> settingsTable_;

    public void setWindow(Window window) {
        this.parentWindow_ = window;
    }

    public void setPartyName(String partyName) {
        this.partyName_ = partyName;
        if (this.partyName_ != null && !this.partyName_.isEmpty()) {
            SettingManager settingMgr = SettingManager.getInstance();
            String path = settingMgr.get("MOXKIRIYA_USER_DIR");
            try {
                String text;
                Hashtable<String, Boolean> partyTable;
                this.settingsTable_ = settingMgr.loadConfigSettings(path, this.partyName_);
                this.textFieldPartyName.setText(this.partyName_);
                if (this.partyName_ != null && !this.partyName_.isEmpty()) {
                    this.textFieldPartyName.setEditable(false);
                    this.textFieldPartyName.setDisable(true);
                }
                if ((partyTable = settingMgr.getPartyTable()).get(this.partyName_).booleanValue()) {
                    this.checkBoxDefaultParty.setSelected(true);
                }
                this.textFieldApproot.setText((text = this.settingsTable_.get("moxkiriyaroot")) == null ? "" : text);
                String clusterSetting = this.settingsTable_.get("clustersetting");
                if (clusterSetting != null && clusterSetting.equals("true")) {
                    this.checkBoxClusterSetting.setSelected(true);
                    text = this.settingsTable_.get("dbserverurl");
                    this.textFieldDBServerURL.setText(text == null ? "" : text);
                    text = this.settingsTable_.get("dbserverport");
                    this.textFieldPortNumber.setText(text == null ? "" : text);
                    text = this.settingsTable_.get("jdbcdriver");
                    this.textFieldJDBCDriver.setText(text == null ? "" : text);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void initialize(URL url, ResourceBundle resource) {
        super.initialize(url, resource);
        this.buttonOK.setDisable(true);
        ChangeListener<String> textFieldchangeListener = new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> arg0, String oldValue, String newValue) {
                ConfigSettingsDialogController.this.buttonOK.setDisable(ConfigSettingsDialogController.this.canEnableOKButton());
            }
        };
        this.textFieldPartyName.textProperty().addListener(textFieldchangeListener);
        this.textFieldApproot.textProperty().addListener(textFieldchangeListener);
        this.textFieldDBServerURL.textProperty().addListener(textFieldchangeListener);
        this.textFieldPortNumber.textProperty().addListener(textFieldchangeListener);
        this.textFieldJDBCDriver.textProperty().addListener(textFieldchangeListener);
        this.checkBoxClusterSetting.selectedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    ConfigSettingsDialogController.this.textFieldDBServerURL.setDisable(false);
                    ConfigSettingsDialogController.this.textFieldPortNumber.setDisable(false);
                    ConfigSettingsDialogController.this.textFieldJDBCDriver.setDisable(false);
                } else {
                    ConfigSettingsDialogController.this.textFieldDBServerURL.setDisable(true);
                    ConfigSettingsDialogController.this.textFieldPortNumber.setDisable(true);
                    ConfigSettingsDialogController.this.textFieldJDBCDriver.setDisable(true);
                }
                ConfigSettingsDialogController.this.buttonOK.setDisable(ConfigSettingsDialogController.this.canEnableOKButton());
            }
        });
    }

    @FXML
    void onActionButtonChooseDirectory(ActionEvent event) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        String home = SettingManager.getInstance().get("USER_HOME");
        directoryChooser.setInitialDirectory(new File(home));
        File choicedDirectory = directoryChooser.showDialog(this.parentWindow_);
        if (choicedDirectory.exists() && choicedDirectory.isDirectory()) {
            this.textFieldApproot.setText(choicedDirectory.getPath());
            this.buttonOK.setDisable(false);
        }
    }

    @FXML
    void onActionButtonOK(ActionEvent event) {
        try {
            if (this.partyName_ == null) {
                SettingManager settingMgr = SettingManager.getInstance();
                String selectedParty = this.textFieldPartyName.getText();
                String moxkiriyaRoot = this.textFieldApproot.getText();
                settingMgr.putParty(selectedParty, this.checkBoxDefaultParty.isSelected());
                settingMgr.setSelectedParty(selectedParty);
                settingMgr.put("moxkiriyaroot", moxkiriyaRoot);
                settingMgr.put("wikiroot", String.valueOf(moxkiriyaRoot) + "/" + "wikiroot");
                File wikiroot = new File(settingMgr.get("wikiroot"));
                if (!wikiroot.exists()) {
                    wikiroot.mkdirs();
                }
                if (this.checkBoxClusterSetting.selectedProperty().get()) {
                    settingMgr.put("clustersetting", "true");
                    settingMgr.put("dbserverurl", this.textFieldDBServerURL.getText());
                    settingMgr.put("dbserverport", this.textFieldPortNumber.getText());
                    settingMgr.put("jdbcdriver", this.textFieldJDBCDriver.getText());
                } else {
                    settingMgr.put("clustersetting", "false");
                    settingMgr.put("dbserverurl", "");
                    settingMgr.put("dbserverport", "");
                    settingMgr.put("jdbcdriver", "");
                }
                settingMgr.save();
                settingMgr.putParty(selectedParty, true);
            }
            ((Node)event.getSource()).getScene().getWindow().hide();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean canEnableOKButton() {
        String text;
        boolean isDisable = this.textFieldPartyName.getText().isEmpty();
        if (!isDisable) {
            text = this.textFieldApproot.getText();
            boolean bl = isDisable = text == null || text.isEmpty();
        }
        if (this.checkBoxClusterSetting.selectedProperty().getValue().booleanValue()) {
            if (!isDisable) {
                text = this.textFieldDBServerURL.getText();
                boolean bl = isDisable = text == null || text.isEmpty();
            }
            if (!isDisable) {
                text = this.textFieldPortNumber.getText();
                boolean bl = isDisable = text == null || text.isEmpty();
            }
            if (!isDisable) {
                text = this.textFieldJDBCDriver.getText();
                isDisable = text == null || text.isEmpty();
            }
        }
        return isDisable;
    }

    public Hashtable<String, String> getSettingsTable() {
        Hashtable<String, String> settingsTable = new Hashtable<String, String>();
        String moxkiriyaRoot = this.textFieldApproot.getText();
        settingsTable.put("moxkiriyaroot", moxkiriyaRoot);
        settingsTable.put("wikiroot", String.valueOf(moxkiriyaRoot) + "/" + "wikiroot");
        if (this.checkBoxClusterSetting.selectedProperty().get()) {
            settingsTable.put("clustersetting", "true");
            settingsTable.put("dbserverurl", this.textFieldDBServerURL.getText());
            settingsTable.put("dbserverport", this.textFieldPortNumber.getText());
            settingsTable.put("jdbcdriver", this.textFieldJDBCDriver.getText());
        } else {
            settingsTable.put("clustersetting", "false");
            settingsTable.put("dbserverurl", "");
            settingsTable.put("dbserverport", "");
            settingsTable.put("jdbcdriver", "");
        }
        return settingsTable;
    }

    public boolean getDefaultPartyCheckValue() {
        return this.checkBoxDefaultParty.isSelected();
    }

    public String getPartyName() {
        return this.textFieldPartyName.getText();
    }
}

