/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserBase;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserCreator;

public class WikiBlockquoteBlockParser
extends WikiBlockParserBase {
    private static final String START_TAG = "<blockquote";
    private static final String END_TAG = "</blockquote>\n";
    private static final String NOTATION_REGEX_LINEHEAD = "^>";
    private static final String NOTATION_REGEX_LINETAIL = "";
    public static final String NOTATION_REGEX = "^>..*";
    private boolean isBlockEnd_ = false;
    private String remain_;

    public WikiBlockquoteBlockParser(WikiEngine wikiEngine) {
        this(wikiEngine, WikiBlockParser.Status.INIT);
    }

    public WikiBlockquoteBlockParser(WikiEngine wikiEngine, WikiBlockParser.Status status) {
        super(wikiEngine);
        this.status_ = status;
    }

    @Override
    public String startElementProcess(String line, StringBuffer buf) {
        this.status_ = WikiBlockParser.Status.OPEN;
        buf.append("<blockquote class=\"quotation\">");
        return line;
    }

    @Override
    public String parse(String line, StringBuffer buf) throws Exception {
        if (line.matches(NOTATION_REGEX)) {
            String token = line.substring(line.indexOf(">"));
            int countToken = this.countToken(token, '>');
            if (countToken > 1) {
                String daughterPart = token.substring(1);
                if (this.status_ == WikiBlockParser.Status.OPEN) {
                    this.startDaughterParse(new WikiBlockParserCreator.Creator(){

                        @Override
                        public WikiBlockquoteBlockParser create(WikiEngine wikiEngine) {
                            return new WikiBlockquoteBlockParser(wikiEngine, WikiBlockParser.Status.OPEN);
                        }
                    });
                    this.daughterParser_.startElementProcess(daughterPart, buf);
                }
                this.daughterParser_.parse(daughterPart, buf);
            } else {
                if (this.status_ == WikiBlockParser.Status.NESTING) {
                    this.daughterParser_.endElementProcess(line, buf);
                    this.daughterParser_ = null;
                    this.status_ = WikiBlockParser.Status.OPEN;
                }
                buf.append("<div>");
                super.parse(token.substring(countToken), buf);
                buf.append("</div>\n");
                this.remain_ = NOTATION_REGEX_LINETAIL;
            }
        } else {
            this.isBlockEnd_ = true;
            this.remain_ = line;
        }
        return NOTATION_REGEX_LINETAIL;
    }

    @Override
    public String endElementProcess(String line, StringBuffer buf) {
        if (this.status_ == WikiBlockParser.Status.NESTING) {
            this.daughterParser_.endElementProcess(line, buf);
        }
        buf.append("</blockquote>\n\n");
        return this.remain_;
    }

    @Override
    public boolean isBlockEnd() {
        return this.isBlockEnd_;
    }
}

