/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserBase;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserCreator;

public class WikiCodeBlockParser
extends WikiBlockParserBase {
    public static final String NOTATION_REGEX_LINEHEAD = "<code[ \t]*>.*";
    public static final String NOTATION_REGEX_LINETAIL = "<*/[ \t]*code>.*";
    public static final String NOTATION_REGEX = ".*<code[ \t]*>.*.*";

    public WikiCodeBlockParser(WikiEngine wikiEngine) {
        this(wikiEngine, null, WikiBlockParser.Status.INIT);
    }

    public WikiCodeBlockParser(WikiEngine wikiEngine, WikiBlockParser motherParser, WikiBlockParser.Status status) {
        super(wikiEngine);
        this.motherParser_ = motherParser;
        this.status_ = status;
        this.initialStatus_ = status;
    }

    @Override
    public String startElementProcess(String line, StringBuffer buf) {
        char[] charLine = line.toCharArray();
        String previous = "";
        String main = "";
        this.count_ = 0;
        while (this.count_ < charLine.length) {
            String now;
            if (charLine[this.count_] == '<' && (now = line.substring(this.count_)).matches(NOTATION_REGEX_LINEHEAD)) {
                previous = line.substring(0, line.indexOf(now));
                main = now;
                break;
            }
            ++this.count_;
        }
        if (!previous.isEmpty()) {
            buf.append(this.inlineParse(previous));
        }
        return main;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String parse(String line, StringBuffer buf) throws Exception {
        char[] charLine = line.toCharArray();
        this.count_ = 0;
        while (this.count_ < charLine.length) {
            block10: {
                block11: {
                    String tagpart;
                    block13: {
                        String nowLower;
                        String now;
                        block12: {
                            block9: {
                                if (this.status_ != WikiBlockParser.Status.NESTING) break block9;
                                String nestpart = new String(line.substring(this.count_));
                                this.daughterParser_.parse(nestpart, buf);
                                this.count_ += this.daughterParser_.getCount();
                                if (this.daughterParser_.isBlockEnd()) {
                                    this.daughterParser_.endElementProcess(null, buf);
                                    this.status_ = WikiBlockParser.Status.OPEN;
                                    this.daughterParser_ = null;
                                }
                                break block10;
                            }
                            if (charLine[this.count_] != '<') break block11;
                            now = line.substring(this.count_);
                            nowLower = now.toLowerCase();
                            tagpart = now.substring(0, now.indexOf(">") + ">".length());
                            if (!nowLower.matches(NOTATION_REGEX_LINEHEAD)) break block12;
                            this.count_ += tagpart.length() - 1;
                            if (this.status_ != WikiBlockParser.Status.INIT) {
                                tagpart = tagpart.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                            }
                            this.startDaughterParse(new WikiBlockParserCreator.Creator(){

                                @Override
                                public WikiCodeBlockParser create(WikiEngine wikiEngine) {
                                    return new WikiCodeBlockParser(wikiEngine, WikiCodeBlockParser.this, WikiBlockParser.Status.OPEN);
                                }
                            });
                            buf.append(tagpart);
                            break block10;
                        }
                        if (!nowLower.matches(NOTATION_REGEX_LINETAIL)) break block13;
                        if (this.status_ == WikiBlockParser.Status.NESTING) {
                            this.daughterParser_.parse(now, buf);
                            this.count_ += this.daughterParser_.getCount() - 1;
                            if (this.daughterParser_.isBlockEnd()) {
                                this.status_ = WikiBlockParser.Status.OPEN;
                                this.daughterParser_ = null;
                            }
                            break block10;
                        } else {
                            this.remain_ = now.substring(now.indexOf(">") + ">".length());
                            this.count_ += tagpart.length() - 1;
                            if (this.initialStatus_ == WikiBlockParser.Status.OPEN) {
                                this.motherParser_.daughterElementCloseHelper(tagpart);
                            }
                            buf.append(tagpart);
                            this.isBlockEnd_ = true;
                            break;
                        }
                    }
                    this.count_ += tagpart.length() - 1;
                    buf.append(tagpart.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
                    break block10;
                }
                if (this.status_ == WikiBlockParser.Status.OPEN) {
                    buf.append(charLine[this.count_]);
                }
            }
            ++this.count_;
        }
        if (this.initialStatus_ == WikiBlockParser.Status.INIT) {
            buf.append("\n");
        }
        return "";
    }

    @Override
    public String endElementProcess(String line, StringBuffer buf) {
        return this.remain_;
    }

    @Override
    public boolean isBlockEnd() {
        return this.isBlockEnd_;
    }

    @Override
    public String daughterElementCloseHelper(String tagPart) {
        return tagPart.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

