/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserBase;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiTOCBuilder;

public class WikiHnBlockParser
extends WikiBlockParserBase {
    private static final String START_TAG = "<div><h%d ";
    private static final String END_TAG = "</h%d></div>\n";
    private static final String NOTATION_REGEX_LINEHEAD = "^==+";
    private static final String NOTATION_REGEX_LINETAIL = "==+$";
    public static final String NOTATION_REGEX = "^==+..*==+$";
    public static final int HEADERLEVEL_MAX = 6;
    private int headerLevel_;
    private WikiTOCBuilder wikiTOCBuilder_;

    public WikiHnBlockParser(WikiEngine wikiEngine, WikiTOCBuilder wikiTOCBuilder) {
        super(wikiEngine);
        this.wikiTOCBuilder_ = wikiTOCBuilder;
    }

    @Override
    public String startElementProcess(String line, StringBuffer buf) {
        int startCount = this.countToken(line, '=');
        int lastCount = 0;
        char[] lineCharArray = line.toCharArray();
        lastCount = 0;
        while (lastCount < line.length()) {
            if (lineCharArray[lineCharArray.length - lastCount - 1] != '=') break;
            ++lastCount;
        }
        this.headerLevel_ = Math.min(Math.min(startCount, lastCount), 6);
        buf.append(String.format(START_TAG, this.headerLevel_));
        StringBuffer replaceString = new StringBuffer();
        int count = 0;
        while (count < this.headerLevel_) {
            replaceString.append("=");
            ++count;
        }
        String headline = line.replaceFirst("^" + replaceString, "").replaceFirst(replaceString + "$", "").trim();
        buf.append("id=\"" + headline + "\">");
        this.wikiTOCBuilder_.add(headline, this.headerLevel_);
        return headline;
    }

    @Override
    public String endElementProcess(String line, StringBuffer buf) {
        buf.append(String.format(END_TAG, this.headerLevel_));
        return "";
    }

    @Override
    public boolean isBlockEnd() {
        return true;
    }
}

