/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserBase;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserCreator;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiCodeBlockParser;

public class WikiPreBlockParser
extends WikiBlockParserBase {
    public static final String NOTATION_REGEX_LINEHEAD = "<pre[ \t]*>.*";
    public static final String NOTATION_REGEX_LINETAIL = "<*/[ \t]*pre>.*";
    public static final String NOTATION_REGEX = ".*<pre[ \t]*>.*.*";

    public WikiPreBlockParser(WikiEngine wikiEngine) {
        this(wikiEngine, WikiBlockParser.Status.INIT);
    }

    public WikiPreBlockParser(WikiEngine wikiEngine, WikiBlockParser.Status status) {
        super(wikiEngine);
        this.status_ = status;
        this.initialStatus_ = status;
    }

    @Override
    public String startElementProcess(String line, StringBuffer buf) {
        char[] charLine = line.toCharArray();
        String previous = "";
        String main = "";
        this.count_ = 0;
        while (this.count_ < charLine.length) {
            String now;
            if (charLine[this.count_] == '<' && (now = line.substring(this.count_)).matches(NOTATION_REGEX_LINEHEAD)) {
                previous = line.substring(0, line.indexOf(now));
                main = now;
                break;
            }
            ++this.count_;
        }
        if (!previous.isEmpty()) {
            buf.append(this.inlineParse(previous));
        }
        return main;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String parse(String line, StringBuffer buf) throws Exception {
        char[] charLine = line.toCharArray();
        this.count_ = 0;
        while (this.count_ < charLine.length) {
            block8: {
                block9: {
                    String tagpart;
                    block12: {
                        String nowLower;
                        String now;
                        block11: {
                            block10: {
                                block7: {
                                    if (this.status_ != WikiBlockParser.Status.NESTING) break block7;
                                    String nestpart = new String(line.substring(this.count_));
                                    this.daughterParser_.parse(nestpart, buf);
                                    this.count_ += this.daughterParser_.getCount();
                                    if (this.daughterParser_.isBlockEnd()) {
                                        this.daughterParser_.endElementProcess(null, buf);
                                        this.status_ = WikiBlockParser.Status.OPEN;
                                        this.daughterParser_ = null;
                                    }
                                    break block8;
                                }
                                if (charLine[this.count_] != '<') break block9;
                                now = line.substring(this.count_);
                                nowLower = now.toLowerCase();
                                tagpart = now.substring(0, now.indexOf(">") + ">".length());
                                if (!nowLower.matches(NOTATION_REGEX_LINEHEAD)) break block10;
                                this.count_ += tagpart.length() - 1;
                                this.startDaughterParse(new WikiBlockParserCreator.Creator(){

                                    @Override
                                    public WikiPreBlockParser create(WikiEngine wikiEngine) {
                                        return new WikiPreBlockParser(wikiEngine, WikiBlockParser.Status.OPEN);
                                    }
                                });
                                buf.append(tagpart);
                                break block8;
                            }
                            if (!nowLower.matches("<code[ \t]*>.*")) break block11;
                            this.count_ += tagpart.length() - 1;
                            this.startDaughterParse(new WikiBlockParserCreator.Creator(){

                                @Override
                                public WikiCodeBlockParser create(WikiEngine wikiEngine) {
                                    return new WikiCodeBlockParser(wikiEngine, WikiPreBlockParser.this, WikiBlockParser.Status.OPEN);
                                }
                            });
                            buf.append(tagpart);
                            break block8;
                        }
                        if (!nowLower.matches(NOTATION_REGEX_LINETAIL) && !nowLower.matches("<*/[ \t]*code>.*")) break block12;
                        if (this.status_ == WikiBlockParser.Status.NESTING) {
                            this.daughterParser_.parse(now, buf);
                            this.count_ += this.daughterParser_.getCount() - 1;
                            if (this.daughterParser_.isBlockEnd()) {
                                this.status_ = WikiBlockParser.Status.OPEN;
                                this.daughterParser_ = null;
                            }
                            break block8;
                        } else {
                            this.remain_ = now.substring(now.indexOf(">") + ">".length());
                            this.count_ += tagpart.length() - 1;
                            buf.append(tagpart);
                            this.isBlockEnd_ = true;
                            break;
                        }
                    }
                    this.count_ += tagpart.length() - 1;
                    buf.append(tagpart.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
                    break block8;
                }
                if (this.status_ == WikiBlockParser.Status.OPEN) {
                    buf.append(charLine[this.count_]);
                }
            }
            ++this.count_;
        }
        if (this.initialStatus_ == WikiBlockParser.Status.INIT) {
            buf.append("\n");
        }
        return "";
    }

    @Override
    public String endElementProcess(String line, StringBuffer buf) {
        return this.remain_;
    }

    @Override
    public boolean isBlockEnd() {
        return this.isBlockEnd_;
    }

    @Override
    public String daughterElementCloseHelper(String tagPart) {
        return this.motherParser_ != null ? this.motherParser_.daughterElementCloseHelper(tagPart) : tagPart;
    }
}

