/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserBase;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserCreator;
import java.util.LinkedHashMap;

public class WikiTableRowBlockParser
extends WikiBlockParserBase {
    private static final String START_TH_TAG = "<th";
    private static final String END_TH_TAG = "</th>\n";
    private static final String START_TD_TAG = "<td";
    private static final String END_TD_TAG = "</td>\n";
    private static final String NOTATION_REGEX_LINEHEAD = "^[ \t]*[!|]";
    public static final String NOTATION_REGEX = "^[ \t]*[!|].*";
    private static final LinkedHashMap<String, TagPair> tagPairHashMap_ = new LinkedHashMap<String, TagPair>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("!", new TagPair(WikiTableRowBlockParser.START_TH_TAG, WikiTableRowBlockParser.END_TH_TAG));
            this.put("|", new TagPair(WikiTableRowBlockParser.START_TD_TAG, WikiTableRowBlockParser.END_TD_TAG));
        }
    };
    private TagPair tagpair_;
    private static final LinkedHashMap<String, String> selectorMap_ = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("colspan=", "");
            this.put("rowspan=", "");
            this.put("scope=", "");
            this.put("style=", "");
        }
    };
    private WikiBlockParserCreator creator_;
    private StringBuffer rowBuf_;

    public WikiTableRowBlockParser(WikiEngine wikiEngine) {
        this(wikiEngine, WikiBlockParser.Status.INIT);
    }

    public WikiTableRowBlockParser(WikiEngine wikiEngine, WikiBlockParser.Status status) {
        super(wikiEngine);
        this.status_ = status;
        this.creator_ = new WikiBlockParserCreator(wikiEngine);
        this.rowBuf_ = new StringBuffer("");
    }

    @Override
    public String startElementProcess(String line, StringBuffer buf) {
        this.status_ = WikiBlockParser.Status.OPEN;
        String trimedLine = line.trim();
        String firstLetter = trimedLine.substring(0, 1);
        this.tagpair_ = tagPairHashMap_.get(firstLetter);
        buf.append(String.valueOf(this.tagpair_.startTag_) + " ");
        trimedLine = trimedLine.substring(1);
        StringBuffer cellBuf = new StringBuffer("");
        boolean selectorFound = false;
        int count = 0;
        while (count < trimedLine.length()) {
            char letter = trimedLine.charAt(count);
            if (letter == '|') break;
            cellBuf.append(letter);
            if (!selectorFound) {
                for (String key : selectorMap_.keySet()) {
                    if (!cellBuf.toString().equals(key)) continue;
                    selectorFound = true;
                    buf.append(key);
                    break;
                }
            } else {
                buf.append(letter);
            }
            ++count;
        }
        buf.append(">\n");
        if (selectorFound) {
            trimedLine = trimedLine.substring(count + 1);
        }
        return trimedLine;
    }

    @Override
    public String parse(String line, StringBuffer buf) throws Exception {
        if (line.startsWith("|") || line.startsWith("!")) {
            this.isBlockEnd_ = true;
            this.remain_ = line;
            line = "";
        } else {
            if (this.status_ != WikiBlockParser.Status.NESTING) {
                this.startDaughterParse(this.creator_, line);
                line = this.daughterParser_.startElementProcess(line, this.rowBuf_);
            }
            line = this.daughterParser_.parse(line, this.rowBuf_);
            if (this.daughterParser_.isBlockEnd()) {
                line = this.daughterParser_.endElementProcess(line, this.rowBuf_);
                this.status_ = WikiBlockParser.Status.OPEN;
            }
        }
        return line;
    }

    @Override
    public String endElementProcess(String line, StringBuffer buf) {
        if (this.status_ == WikiBlockParser.Status.NESTING) {
            this.daughterParser_.endElementProcess(line, this.rowBuf_);
            this.status_ = WikiBlockParser.Status.OPEN;
        }
        this.flushRowBuf(buf);
        buf.append(this.tagpair_.endTag_);
        return this.remain_;
    }

    private void flushRowBuf(StringBuffer buf) {
        if (this.rowBuf_ != null && this.rowBuf_.length() > 0) {
            buf.append(this.rowBuf_);
            this.rowBuf_ = null;
        }
    }

    static class TagPair {
        String startTag_;
        String endTag_;

        TagPair(String startTag, String endTag) {
            this.startTag_ = startTag;
            this.endTag_ = endTag;
        }
    }
}

