/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.inlineparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiInlineParserBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiBoldInlineParser
extends WikiInlineParserBase {
    public static final String WIKI_TOKEN = "'''";
    public static final String PATTERN_START = "'''[^']";
    public static final String PATTERN_END = "[^']'''";
    public static final String PATTERN_ITALIC_END = "[^']''";
    private static final String START_TAG = "<span id=\"bold\">\n";
    private static final String END_TAG = "</span>\n";

    public WikiBoldInlineParser(WikiEngine wikiEngine) {
        super(wikiEngine);
    }

    public static boolean matches(String line) {
        boolean isMatch = false;
        Matcher startMatcher = Pattern.compile(PATTERN_START).matcher(line);
        if (startMatcher.find()) {
            isMatch = true;
        }
        return isMatch;
    }

    @Override
    public void startElementProcess(StringBuffer buf) {
        buf.append(START_TAG);
    }

    @Override
    public void endElementProcess(StringBuffer buf) {
        buf.append(END_TAG);
    }

    @Override
    public String deleteWikiToken(String line) {
        String deleteTop = line.replaceFirst(WIKI_TOKEN, "");
        if (deleteTop.contains(WIKI_TOKEN)) {
            deleteTop = deleteTop.substring(0, deleteTop.lastIndexOf(WIKI_TOKEN));
        }
        return deleteTop;
    }

    @Override
    public String getStartPattern() {
        return PATTERN_START;
    }

    @Override
    public String getEndPattern() {
        return PATTERN_END;
    }
}

