/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.inlineparser;

import com.wiki.standalone.moxkiriya.SettingManager;
import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiInlineParserBase;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiExternalLinkInlineParser
extends WikiInlineParserBase {
    public static final String WIKI_TOKEN_START = "[";
    public static final String WIKI_TOKEN_END = "]";
    public static final String PATTERN_START = String.valueOf(Pattern.quote("[")) + "[^" + Pattern.quote("[") + "]";
    public static final String PATTERN_END = "[^]]" + Pattern.quote("]");
    private static final String START_TAG = "<a href=";
    private static final String END_TAG = "</a>\n";
    private static final String START_ICON_TAG = "<img src=";
    private static final String END_ICON_TAG = "</img>";
    private static final String EXTERNAL_LINK_ICON = "icon\\Icon_External_Link.png";
    private String url_;
    private String textNode_;
    private static final ArrayList<String> schemeList = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("http://");
            this.add("https://");
            this.add("file://");
        }
    };

    public WikiExternalLinkInlineParser(WikiEngine wikiEngine) {
        super(wikiEngine);
    }

    public static boolean matches(String line) {
        boolean isMatch = false;
        Matcher startMatcher = Pattern.compile(PATTERN_START).matcher(line);
        if (startMatcher.find()) {
            int startIndex = startMatcher.start();
            String startString = line.substring(startIndex + 1);
            Matcher endMatcher = Pattern.compile(PATTERN_END).matcher(startString);
            if (endMatcher.find()) {
                isMatch = WikiExternalLinkInlineParser.isSchemeString(startString);
            }
        }
        return isMatch;
    }

    @Override
    public String[] devideLine(String line) {
        int depth = 0;
        char[] charArrayLine = line.toCharArray();
        int startIndex = -1;
        int endIndex = -1;
        int lastIndex = -1;
        boolean withinElem = false;
        int count = 0;
        while (count < charArrayLine.length) {
            if (charArrayLine[count] == '>') {
                withinElem = false;
            } else {
                if (charArrayLine[count] == '<') {
                    withinElem = true;
                }
                if (!withinElem) {
                    if (charArrayLine[count] == '[') {
                        String startString = line.substring(count + 1);
                        if (WikiExternalLinkInlineParser.isSchemeString(startString)) {
                            if (startIndex != -1) {
                                endIndex = lastIndex;
                                break;
                            }
                            if (depth == 0) {
                                startIndex = count;
                            }
                        } else if (startString.startsWith(WIKI_TOKEN_START)) {
                            endIndex = lastIndex;
                            break;
                        }
                        ++depth;
                    } else if (charArrayLine[count] == ']') {
                        lastIndex = count;
                        if (depth > 0 && --depth == 0) {
                            endIndex = count;
                            break;
                        }
                    }
                }
            }
            ++count;
        }
        if (endIndex == -1) {
            endIndex = lastIndex == -1 ? line.length() - 1 : lastIndex;
        }
        String split0 = line.substring(0, startIndex);
        String split1 = line.substring(startIndex, endIndex + 1);
        String split2 = line.substring(endIndex + 1);
        return new String[]{split0, split1, split2};
    }

    @Override
    public String deleteWikiToken(String line) {
        String deleteTop = line.replaceFirst(Pattern.quote(WIKI_TOKEN_START), "");
        String text = deleteTop.substring(0, deleteTop.lastIndexOf(WIKI_TOKEN_END));
        if (text.contains("|")) {
            this.url_ = text.substring(0, text.indexOf("|"));
            this.textNode_ = text.substring(text.indexOf("|") + "|".length());
        } else {
            this.url_ = text;
            this.textNode_ = text;
        }
        return this.textNode_.replaceAll(Pattern.quote(WIKI_TOKEN_START), "&#91;").replaceAll(Pattern.quote(WIKI_TOKEN_END), "&#93;");
    }

    @Override
    public void startElementProcess(StringBuffer buf) {
        buf.append(START_TAG);
        buf.append("\"");
        buf.append(this.url_);
        buf.append("\">");
    }

    @Override
    public void textNodeProcess(StringBuffer buf, String textNode) {
        buf.append(textNode);
    }

    @Override
    public String getStartPattern() {
        return PATTERN_START;
    }

    @Override
    public void endElementProcess(StringBuffer buf) {
        try {
            buf.append(START_ICON_TAG);
            SettingManager settingMgr = SettingManager.getInstance();
            String Approot = settingMgr.get("moxkiriyaroot");
            String iconPath = String.valueOf(Approot) + "\\" + EXTERNAL_LINK_ICON;
            URL url = new File(iconPath).toURI().toURL();
            buf.append("\"" + url.toString() + "\">");
            buf.append(END_ICON_TAG);
            buf.append(END_TAG);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getEndPattern() {
        return PATTERN_END;
    }

    private static boolean isSchemeString(String line) {
        boolean result = false;
        for (String scheme : schemeList) {
            if (!line.startsWith(scheme)) continue;
            result = true;
            break;
        }
        return result;
    }
}

