/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.inlineparser;

import com.wiki.standalone.moxkiriya.PageData;
import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiInlineParserBase;
import com.wiki.standalone.moxkiriya.util.FileTypeDeterminator;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import org.apache.jackrabbit.util.Base64;

public class WikiInternalLinkInlineParser
extends WikiInlineParserBase {
    public static final String WIKI_TOKEN_START = "[[";
    public static final String WIKI_TOKEN_END = "]]";
    public static final String PATTERN_START = String.valueOf(Pattern.quote("[[")) + "[^" + Pattern.quote("[") + "]";
    public static final String PATTERN_END = "[^]]" + Pattern.quote("]]");
    private static final String START_TAG = "<a href=";
    private static final String END_TAG = "</a>\n";
    public static final String ATTRIBUTE_JCR_UUID = "data-jcr_uuid";
    private static final String IMAGE_START_TAG = "<img src=";
    private static final String IMAGE_END_TAG = "</img>";
    private static final String PAGENAME_PREFIX_FILE = "File:";
    private static final String PAGENAME_PREFIX_COLONFILE = ":File:";
    private static final String PAGENAME_PREFIX_CATEGORY = "Category:";
    private static final String PAGENAME_PREFIX_COLONCATEGORY = ":Category:";
    private static final String PAGENAME_HASH_TITLE = "#title";
    private static final String STYLE_CLASS_NOEXIST = "class=\"noexist\"";
    private String pagename_;
    private String linkpath_;
    private LinkMode linkMode;
    private final LinkedHashMap<LinkMode, TextNodeProcessor> textNodeProcessorMap = new LinkedHashMap<LinkMode, TextNodeProcessor>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(LinkMode.NONE, new TextNodeProcessor(){

                @Override
                public void textNodeProcess(StringBuffer buf, String textNode) {
                }
            });
            this.put(LinkMode.INNERLINK, new TextNodeProcessor(){

                @Override
                public void textNodeProcess(StringBuffer buf, String textNode) {
                    if (!WikiInternalLinkInlineParser.this.linkpath_.isEmpty()) {
                        if (textNode.startsWith(WikiInternalLinkInlineParser.PAGENAME_PREFIX_COLONFILE) || textNode.startsWith(WikiInternalLinkInlineParser.PAGENAME_PREFIX_COLONCATEGORY)) {
                            textNode = textNode.replaceFirst(Pattern.quote(":"), "");
                        }
                        buf.append(textNode);
                    }
                }
            });
            this.put(LinkMode.IMAGERENDER, new TextNodeProcessor(){

                @Override
                public void textNodeProcess(StringBuffer buf, String textNode) {
                    try {
                        HashMap<String, PageData> nowPageDataMap;
                        PageData nowPageData;
                        String mediaType = null;
                        StringBuffer databuf = new StringBuffer("");
                        HashMap<String, PageData> pageDataMap = (this).WikiInternalLinkInlineParser.this.wikiEngine_.queryPageTitle(WikiInternalLinkInlineParser.this.linkpath_);
                        PageData.FileData fileData = null;
                        PageData pageData = null;
                        if (!pageDataMap.isEmpty()) {
                            pageData = pageDataMap.values().iterator().next();
                            fileData = pageData.getFileData();
                        }
                        if (fileData == null && (nowPageData = (nowPageDataMap = (this).WikiInternalLinkInlineParser.this.wikiEngine_.getPageDataMap()).values().iterator().next()).getNamespace().equals("File")) {
                            String title = nowPageData.getTitle();
                            if (WikiInternalLinkInlineParser.this.linkpath_.equals(WikiInternalLinkInlineParser.PAGENAME_PREFIX_FILE + title)) {
                                fileData = nowPageData.getFileData();
                            }
                        }
                        if (fileData != null) {
                            mediaType = fileData.getMimeType();
                            InputStream inputStream = fileData.getInputStream();
                            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                            if (mediaType.startsWith("image/")) {
                                Base64.encode(inputStream, outputStream);
                                databuf.append(outputStream.toString());
                            }
                            buf.append(WikiInternalLinkInlineParser.IMAGE_START_TAG);
                            if (databuf.length() > 0) {
                                buf.append("\"data:");
                                buf.append(String.valueOf(mediaType) + ";base64,");
                                buf.append(databuf);
                                buf.append("\"");
                            }
                            buf.append(" alt=\"");
                            buf.append(textNode);
                            buf.append("\"");
                            buf.append(" title=\"");
                            buf.append(textNode);
                            buf.append("\" >");
                            buf.append(WikiInternalLinkInlineParser.IMAGE_END_TAG);
                        } else {
                            buf.append(textNode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.put(LinkMode.ATTACHEDFILELINK, new TextNodeProcessor(){

                @Override
                public void textNodeProcess(StringBuffer buf, String textNode) {
                    String basename = WikiInternalLinkInlineParser.this.linkpath_.substring(WikiInternalLinkInlineParser.this.linkpath_.lastIndexOf("\\") + "\\".length());
                    buf.append(basename);
                }
            });
        }
    };

    public WikiInternalLinkInlineParser(WikiEngine wikiEngine) {
        super(wikiEngine);
    }

    public static boolean matches(String line) {
        boolean isMatch = false;
        Matcher startMatcher = Pattern.compile(PATTERN_START).matcher(line);
        if (startMatcher.find()) {
            int startIndex = startMatcher.start();
            String subline = line.substring(startIndex);
            Matcher endMatcher = Pattern.compile(PATTERN_END).matcher(subline);
            if (endMatcher.find()) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    @Override
    public String[] devideLine(String line) {
        char[] charArrayLine = line.toCharArray();
        int startIndex = -1;
        int endIndex = -1;
        boolean withinElem = false;
        int count = 0;
        while (count < charArrayLine.length) {
            if (charArrayLine[count] == '>') {
                withinElem = false;
            } else {
                if (charArrayLine[count] == '<') {
                    withinElem = true;
                }
                if (!withinElem) {
                    String endString;
                    if (charArrayLine[count] == '[') {
                        String startString = line.substring(count);
                        if (startString.startsWith(WIKI_TOKEN_START)) {
                            startIndex = count;
                        }
                    } else if (charArrayLine[count] == ']' && startIndex != -1 && (endString = line.substring(count)).startsWith(WIKI_TOKEN_END)) {
                        endIndex = count;
                        break;
                    }
                }
            }
            ++count;
        }
        String split0 = line.substring(0, startIndex);
        String split1 = line.substring(startIndex, endIndex + 2);
        String split2 = line.substring(endIndex + 2);
        return new String[]{split0.replaceAll(Pattern.quote("["), "&#91;").replaceAll(Pattern.quote("]"), "&#93;"), split1, split2};
    }

    @Override
    public String deleteWikiToken(String line) {
        String deleteToken;
        String deleteTop = line.replaceFirst(Pattern.quote(WIKI_TOKEN_START), "");
        String textNode = deleteToken = deleteTop.substring(0, deleteTop.lastIndexOf(WIKI_TOKEN_END));
        if (deleteToken.contains("|")) {
            this.pagename_ = deleteToken.substring(0, deleteToken.indexOf("|"));
            textNode = deleteToken.substring(deleteToken.indexOf("|") + "|".length());
            if (textNode.equals(PAGENAME_HASH_TITLE)) {
                textNode = this.pagename_.substring(this.pagename_.lastIndexOf(":") + ":".length());
            }
        } else {
            this.pagename_ = deleteToken;
        }
        return textNode;
    }

    @Override
    public void startElementProcess(StringBuffer buf) {
        try {
            this.linkpath_ = this.buildLinkpathFromPagename(this.pagename_);
            if (!this.linkpath_.isEmpty()) {
                buf.append(START_TAG);
                buf.append("\"");
                buf.append(String.valueOf(this.linkpath_) + "\" ");
                HashMap<String, PageData> pageDataMap = this.wikiEngine_.queryPageTitle(this.linkpath_);
                if (pageDataMap.size() == 0) {
                    buf.append(STYLE_CLASS_NOEXIST);
                } else if (pageDataMap.size() == 1) {
                    Set<String> key = pageDataMap.keySet();
                    PageData pageData = pageDataMap.get(key.iterator().next());
                    Node node = pageData.getNode();
                    buf.append(" data-jcr_uuid=\"");
                    buf.append(node.getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString());
                    buf.append("\"");
                }
                buf.append(">");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void textNodeProcess(StringBuffer buf, String textNode) {
        this.textNodeProcessorMap.get((Object)this.linkMode).textNodeProcess(buf, textNode);
    }

    @Override
    public String getStartPattern() {
        return PATTERN_START;
    }

    @Override
    public void endElementProcess(StringBuffer buf) {
        if (!this.linkpath_.isEmpty()) {
            buf.append(END_TAG);
        }
        this.linkMode = LinkMode.NONE;
    }

    @Override
    public String getEndPattern() {
        return PATTERN_END;
    }

    private String buildLinkpathFromPagename(String pagename) throws Exception {
        String linkpath = null;
        if (pagename.startsWith(PAGENAME_PREFIX_FILE)) {
            if (FileTypeDeterminator.isImageFile(pagename)) {
                this.linkMode = LinkMode.IMAGERENDER;
                linkpath = this.buildImageLinkpath(pagename);
            } else {
                this.linkMode = LinkMode.ATTACHEDFILELINK;
                linkpath = this.buildAttachLinkpath(pagename);
            }
        } else if (pagename.startsWith(PAGENAME_PREFIX_CATEGORY)) {
            this.linkMode = LinkMode.INNERLINK;
            linkpath = "";
        } else {
            this.linkMode = LinkMode.INNERLINK;
            linkpath = this.buildInternalLinkpath(pagename);
        }
        return linkpath;
    }

    private String buildAttachLinkpath(String pagename) {
        return pagename.substring(1);
    }

    private String buildImageLinkpath(String pagename) {
        return pagename;
    }

    private String buildInternalLinkpath(String pagename) throws Exception {
        if (pagename.startsWith(PAGENAME_PREFIX_COLONFILE) || pagename.startsWith(PAGENAME_PREFIX_COLONCATEGORY)) {
            pagename = pagename.replaceFirst(Pattern.quote(":"), "");
        }
        return pagename;
    }

    private static enum LinkMode {
        NONE,
        INNERLINK,
        IMAGERENDER,
        ATTACHEDFILELINK;

    }

    private static interface TextNodeProcessor {
        public void textNodeProcess(StringBuffer var1, String var2);
    }
}

