/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.inlineparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiInlineParserBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiOrderedListItemInlineParser
extends WikiInlineParserBase {
    public static final String WIKI_TOKEN = "# ";
    public static final String PATTERN_START = "^[ \t]*# ";
    public static final String PATTERN_END = "$";
    private static final String START_TAG = "<li>";
    private static final String END_TAG = "</li>\n";

    public WikiOrderedListItemInlineParser(WikiEngine wikiEngine) {
        super(wikiEngine);
    }

    public static boolean matches(String line) {
        Matcher startMatcher = Pattern.compile(PATTERN_START).matcher(line);
        return startMatcher.find();
    }

    @Override
    public void startElementProcess(StringBuffer buf) {
        buf.append(START_TAG);
    }

    @Override
    public void endElementProcess(StringBuffer buf) {
        buf.append(END_TAG);
    }

    @Override
    public String deleteWikiToken(String line) {
        return line.replaceFirst(WIKI_TOKEN, "");
    }

    @Override
    public String getStartPattern() {
        return PATTERN_START;
    }

    @Override
    public String getEndPattern() {
        return PATTERN_END;
    }
}

