/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.helpers.Util;

public class SimpleLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -632788891211436180L;
    private static long startTime = System.currentTimeMillis();
    private static final String CONFIGURATION_FILE = "simplelogger.properties";
    private static final String systemPrefix = "org.slf4j.simplelogger.";
    private static final Properties simpleLoggerProps = new Properties();
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS Z";
    private static boolean showLogName = true;
    private static boolean showShortName = false;
    private static boolean showDateTime = false;
    private static String dateTimeFormat = "yyyy-MM-dd HH:mm:ss:SSS Z";
    private static boolean showThreadName = true;
    private static DateFormat dateFormatter = null;
    public static final int LOG_LEVEL_TRACE = 0;
    public static final int LOG_LEVEL_DEBUG = 10;
    public static final int LOG_LEVEL_INFO = 20;
    public static final int LOG_LEVEL_WARN = 30;
    public static final int LOG_LEVEL_ERROR = 40;
    public static final int LOG_LEVEL_ALL = -10;
    public static final int LOG_LEVEL_OFF = 50;
    protected int currentLogLevel = 20;
    private transient String shortLogName = null;

    private static String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? simpleLoggerProps.getProperty(name) : prop;
    }

    private static String getStringProperty(String name, String defaultValue) {
        String prop = SimpleLogger.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    private static boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = SimpleLogger.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    SimpleLogger(String name) {
        this.name = name;
        this.currentLogLevel = 20;
        String lvl = SimpleLogger.getStringProperty("org.slf4j.simplelogger.log." + name);
        int i = String.valueOf(name).lastIndexOf(".");
        while (null == lvl && i > -1) {
            name = name.substring(0, i);
            lvl = SimpleLogger.getStringProperty("org.slf4j.simplelogger.log." + name);
            i = String.valueOf(name).lastIndexOf(".");
        }
        if (null == lvl) {
            lvl = SimpleLogger.getStringProperty("org.slf4j.simplelogger.defaultlog");
        }
        if ("all".equalsIgnoreCase(lvl)) {
            this.currentLogLevel = -10;
        } else if ("trace".equalsIgnoreCase(lvl)) {
            this.currentLogLevel = 0;
        } else if ("debug".equalsIgnoreCase(lvl)) {
            this.currentLogLevel = 10;
        } else if ("info".equalsIgnoreCase(lvl)) {
            this.currentLogLevel = 20;
        } else if ("warn".equalsIgnoreCase(lvl)) {
            this.currentLogLevel = 30;
        } else if ("error".equalsIgnoreCase(lvl)) {
            this.currentLogLevel = 40;
        } else if ("off".equalsIgnoreCase(lvl)) {
            this.currentLogLevel = 50;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(int level, String message, Throwable t) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        StringBuffer buf = new StringBuffer(32);
        if (showDateTime) {
            String dateText;
            Date now = new Date();
            DateFormat dateFormat = dateFormatter;
            synchronized (dateFormat) {
                dateText = dateFormatter.format(now);
            }
            buf.append(dateText);
            buf.append(' ');
        } else {
            buf.append(System.currentTimeMillis() - startTime);
            buf.append(' ');
        }
        if (showThreadName) {
            buf.append('[');
            buf.append(Thread.currentThread().getName());
            buf.append("] ");
        }
        switch (level) {
            case 0: {
                buf.append("TRACE");
                break;
            }
            case 10: {
                buf.append("DEBUG");
                break;
            }
            case 20: {
                buf.append("INFO");
                break;
            }
            case 30: {
                buf.append("WARN");
                break;
            }
            case 40: {
                buf.append("ERROR");
            }
        }
        buf.append(' ');
        if (showShortName) {
            if (this.shortLogName == null) {
                this.shortLogName = this.name.substring(this.name.lastIndexOf(".") + 1);
                this.shortLogName = this.shortLogName.substring(this.shortLogName.lastIndexOf("/") + 1);
            }
            buf.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (showLogName) {
            buf.append(String.valueOf(this.name)).append(" - ");
        }
        buf.append(message);
        System.err.println(buf.toString());
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.err.flush();
    }

    private void formatAndLog(int level, String format, Object arg1, Object arg2) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.format(format, arg1, arg2);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    private void formatAndLog(int level, String format, Object[] argArray) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat(format, argArray);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    public void trace(String msg) {
        this.log(0, msg, null);
    }

    public void trace(String format, Object param1) {
        this.formatAndLog(0, format, param1, null);
    }

    public void trace(String format, Object param1, Object param2) {
        this.formatAndLog(0, format, param1, param2);
    }

    public void trace(String format, Object[] argArray) {
        this.formatAndLog(0, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(0, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(10);
    }

    public void debug(String msg) {
        this.log(10, msg, null);
    }

    public void debug(String format, Object param1) {
        this.formatAndLog(10, format, param1, null);
    }

    public void debug(String format, Object param1, Object param2) {
        this.formatAndLog(10, format, param1, param2);
    }

    public void debug(String format, Object[] argArray) {
        this.formatAndLog(10, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.log(10, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(20);
    }

    public void info(String msg) {
        this.log(20, msg, null);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(20, format, arg, null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(20, format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.formatAndLog(20, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.log(20, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(30);
    }

    public void warn(String msg) {
        this.log(30, msg, null);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(30, format, arg, null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(30, format, arg1, arg2);
    }

    public void warn(String format, Object[] argArray) {
        this.formatAndLog(30, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.log(30, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(40);
    }

    public void error(String msg) {
        this.log(40, msg, null);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(40, format, arg, null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(40, format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.formatAndLog(40, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(40, msg, t);
    }

    static {
        InputStream in = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(SimpleLogger.CONFIGURATION_FILE);
                }
                return ClassLoader.getSystemResourceAsStream(SimpleLogger.CONFIGURATION_FILE);
            }
        });
        if (null != in) {
            try {
                simpleLoggerProps.load(in);
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        showLogName = SimpleLogger.getBooleanProperty("org.slf4j.simplelogger.showlogname", showLogName);
        showShortName = SimpleLogger.getBooleanProperty("org.slf4j.simplelogger.showShortLogname", showShortName);
        showDateTime = SimpleLogger.getBooleanProperty("org.slf4j.simplelogger.showdatetime", showDateTime);
        showThreadName = SimpleLogger.getBooleanProperty("org.slf4j.simplelogger.showthreadname", showThreadName);
        dateTimeFormat = SimpleLogger.getStringProperty("org.slf4j.simplelogger.dateTimeFormat", dateTimeFormat);
        if (showDateTime) {
            try {
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException e) {
                Util.report("Bad date format in simplelogger.properties; reverting to default", e);
                dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
        }
    }
}

