#!/usr/bin/perl

BEGIN {
	use File::Basename;
	use File::Spec;
	use lib File::Spec->catdir(dirname(__FILE__), '..', 'extlib');
}

use Getopt::Long;
use Acme::Lou;
use strict;

my $lou_rate = 100;
my $mecab_charset = 'utf-8';
GetOptions(
	'lou_rate=i' => \$lou_rate,
	'mecab_charset=s' => \$mecab_charset,
);

my $str = join('', <>);

if ($lou_rate <= 1 || $lou_rate >= 100) {
	$lou_rate = 100;
}

my $lou = new Acme::Lou(
	mecab_charset => $mecab_charset,
);

print($lou->translate($str, {
	is_html      => 1,
	lou_rate     => $lou_rate,
	html_fx_rate => 100,
}));
