<?php
# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

function smarty_modifier_lou($text, $arg) {
	$rate = ctype_digit($arg) ? round($arg) : 100;
	if ($rate <= 1 || $rate >= 100) {
		$rate = 100;
	}

	$lou = dirname(dirname(realpath(__FILE__))) . DIRECTORY_SEPARATOR
		. 'bin' . DIRECTORY_SEPARATOR . 'lou.pl';

	global $mt;
	$config = $mt->db->fetch_plugin_config('Lou', 'system');

	$descriptorspec = array(
		0 => array("pipe", "r"),
		1 => array("pipe", "w"),
		2 => array("pipe", "w"),
	);
	$pipes = array();

	$proc = proc_open(
		$lou . ' -lou_rate ' . $rate
		. ' -mecab_charset ' . $config['mecab_charset'],
		$descriptorspec, $pipes, null, null
	);

	if (is_resource($proc)) {
		fwrite($pipes[0], $text);
		fclose($pipes[0]);

		$text = '';
		while ($c = fread($pipes[1], 1024)) {
			$text .= $c;
		}
		fclose($pipes[1]);
		fclose($pipes[2]);
	}

	return $text;
}

?>
