/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.reflect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.mtzky.io.IOUtils;
import org.mtzky.reflect.IterableUtils;

public class PackageDesc {
    private static final Set<JavaFileObject.Kind> KINDS = EnumSet.of(JavaFileObject.Kind.CLASS);
    private static final IterableUtils.Find<Class<?>> ALL = new IterableUtils.Find<Class<?>>(){

        @Override
        public boolean call(Class<?> value) {
            return true;
        }
    };
    private final List<Class<?>> classes;

    public PackageDesc(String packageName) throws IOException, ClassNotFoundException {
        this(packageName, ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageDesc(String packageName, IterableUtils.Find<Class<?>> filter) throws IOException, ClassNotFoundException {
        if (packageName == null) {
            throw new NullPointerException("packageName");
        }
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        String p = packageName.endsWith(".") ? packageName : packageName + '.';
        StandardJavaFileManager manager = null;
        try {
            ArrayList classes = new ArrayList();
            manager = ToolProvider.getSystemJavaCompiler().getStandardFileManager(new DiagnosticCollector(), null, null);
            for (JavaFileObject obj : manager.list(StandardLocation.CLASS_PATH, packageName, KINDS, false)) {
                String n = obj.getName();
                Class<?> c = Class.forName(p + n.substring(0, n.lastIndexOf(46)));
                if (!filter.call(c)) continue;
                classes.add(c);
            }
            this.classes = Collections.unmodifiableList(classes);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(manager);
            throw throwable;
        }
        IOUtils.closeQuietly(manager);
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }

    public <T> Class<T> findClass(IterableUtils.Find<Class<?>> callback) {
        return IterableUtils.each(this.classes, callback);
    }
}

