/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.reflect;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mtzky.reflect.InvocationTargetRuntimeException;

public class PropDesc {
    private final Method getter;
    private final Method setter;
    private final Field field;
    private final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private final String name;

    public PropDesc(String name, Class<?> beanClass) {
        PropertyDescriptor desc;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        this.name = name;
        try {
            desc = new PropertyDescriptor(name, beanClass);
        }
        catch (IntrospectionException e) {
            this.getter = null;
            this.setter = null;
            try {
                this.field = beanClass.getField(name);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Requires the pair of getter and setter or the public field: " + name, t);
            }
            this.addAnnotations(this.field.getAnnotations());
            return;
        }
        this.getter = desc.getReadMethod();
        this.setter = desc.getWriteMethod();
        this.field = null;
        this.addAnnotations(this.setter.getAnnotations());
        this.addAnnotations(this.getter.getAnnotations());
    }

    public PropDesc(Method accessor) {
        this(PropDesc.calcName(accessor), accessor.getDeclaringClass());
    }

    public PropDesc(Method getter, Method setter) {
        this(PropDesc.calcName(getter), getter, setter);
    }

    public PropDesc(String name, Method getter, Method setter) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (getter == null) {
            throw new NullPointerException("getter");
        }
        if (setter == null) {
            throw new NullPointerException("setter");
        }
        this.name = name;
        this.getter = getter;
        this.setter = setter;
        this.field = null;
        this.addAnnotations(setter.getAnnotations());
        this.addAnnotations(getter.getAnnotations());
    }

    public PropDesc(Field field) {
        this(field.getName(), field);
    }

    public PropDesc(String name, Field field) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (field == null) {
            throw new NullPointerException("field");
        }
        this.name = name;
        this.getter = null;
        this.setter = null;
        this.field = field;
        this.addAnnotations(field.getAnnotations());
    }

    private static String calcName(Method accessor) {
        String n = accessor.getName();
        int len = n.length();
        if (len < 3) {
            throw new IllegalArgumentException("Invalid method name: " + accessor);
        }
        Class<?> returnType = accessor.getReturnType();
        if ((returnType == Boolean.TYPE || returnType == Boolean.class) && n.startsWith("is")) {
            return n.substring(2, 3).toLowerCase(Locale.ENGLISH) + n.substring(3);
        }
        if (len < 4 || !n.startsWith("get") && !n.startsWith("set")) {
            throw new IllegalArgumentException("Invalid method name: " + accessor);
        }
        return n.substring(3, 4).toLowerCase(Locale.ENGLISH) + n.substring(4);
    }

    private void addAnnotations(Annotation[] annotations) {
        for (Annotation a : annotations) {
            this.annotations.put(a.annotationType(), a);
        }
    }

    public <T> T get(Object obj) {
        try {
            return (T)(this.getter != null ? this.getter.invoke(obj, new Object[0]) : this.field.get(obj));
        }
        catch (Exception e) {
            String fmt = "FAILED to get a value from the property '%s'";
            throw new InvocationTargetRuntimeException(String.format("FAILED to get a value from the property '%s'", this.name), e);
        }
    }

    public void set(Object obj, Object value) {
        try {
            if (this.setter != null) {
                this.setter.invoke(obj, value);
            } else {
                this.field.set(obj, value);
            }
        }
        catch (Exception e) {
            String fmt = "FAILED to set [%s] to the property '%s'";
            Object[] args = new Object[]{value, this.name};
            throw new InvocationTargetRuntimeException(String.format("FAILED to set [%s] to the property '%s'", args), e);
        }
    }

    public Class<?> getType() {
        if (this.getter != null) {
            return this.getter.getReturnType();
        }
        return this.field.getType();
    }

    public String getName() {
        return this.name;
    }

    public boolean hasGetter() {
        return this.getter != null;
    }

    public boolean hasSetter() {
        return this.getter != null;
    }

    public boolean hasField() {
        return this.field != null;
    }

    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[this.annotations.size()]);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotations.get(annotationClass);
    }

    public Class<?> getDeclaringClass() {
        if (this.getter != null) {
            return this.getter.getDeclaringClass();
        }
        return this.field.getDeclaringClass();
    }
}

