/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.ControlWindowCanvas;
import controlP5.ControlWindowKeyListener;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerList;
import controlP5.DropdownList;
import controlP5.Knob;
import controlP5.ListBox;
import controlP5.Numberbox;
import controlP5.PAppletWindow;
import controlP5.Slider;
import controlP5.Tab;
import controlP5.Textarea;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlWindow
implements MouseWheelListener,
WindowFocusListener {
    protected ControlP5 controlP5;
    protected int mouseX;
    protected int mouseY;
    protected int pmouseX;
    protected int pmouseY;
    protected boolean mousePressed;
    protected boolean mouselock;
    protected Controller<?> isControllerActive;
    public int background = 0;
    protected CColor color = new CColor();
    private String _myName = "main";
    protected PApplet _myApplet;
    private boolean isPAppletWindow;
    protected ControllerList _myTabs;
    protected boolean isVisible = true;
    protected boolean isInit = false;
    protected boolean isRemove = false;
    protected CDrawable _myDrawable;
    protected boolean isAutoDraw;
    protected boolean isUpdate;
    public static final int NORMAL = 0;
    public static final int ECONOMIC = 1;
    protected List<ControlWindowCanvas> _myControlWindowCanvas;
    private List<ControllerInterface<?>> mouseoverlist;
    private boolean isMouseOver;
    protected boolean isDrawBackground = true;
    protected boolean isUndecorated = false;
    protected boolean is3D;
    protected PVector autoPosition = new PVector(10.0f, 30.0f, 0.0f);
    protected float tempAutoPositionHeight = 0.0f;
    protected boolean rendererNotification = false;
    protected PVector positionOfTabs = new PVector(0.0f, 0.0f, 0.0f);
    private boolean isMouse = true;
    private Pointer _myPointer;
    private boolean mousewheel = true;
    private int _myFrameCount = 0;
    private int mouseWheelMoved = 0;
    private boolean isReset = false;

    public ControlWindow(ControlP5 controlP5, PApplet pApplet) {
        this.mouseoverlist = new ArrayList();
        this.controlP5 = controlP5;
        this._myApplet = pApplet;
        this._myApplet.registerMouseEvent((Object)this);
        this._myApplet.addMouseWheelListener((MouseWheelListener)this);
        try {
            this._myApplet.frame.addWindowFocusListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isAutoDraw = true;
        this.init();
    }

    protected void init() {
        this._myPointer = new Pointer();
        String string = this._myApplet.g.getClass().toString().toLowerCase();
        this.is3D = string.contains("gl") || string.contains("3d");
        this._myTabs = new ControllerList();
        this._myControlWindowCanvas = new ArrayList<ControlWindowCanvas>();
        if (this._myApplet instanceof PAppletWindow) {
            this._myName = ((PAppletWindow)this._myApplet).name();
            this.isPAppletWindow = true;
            ((PAppletWindow)this._myApplet).setControlWindow(this);
        }
        if (this._myApplet instanceof PAppletWindow) {
            this.background = -16777216;
        }
        if (!this.isInit) {
            if (this._myApplet instanceof PAppletWindow) {
                this._myApplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
            } else {
                this.controlP5.keyHandler.update(this);
            }
        }
        this._myTabs.add(new Tab(this.controlP5, this, "global"));
        this._myTabs.add(new Tab(this.controlP5, this, "default"));
        this.activateTab((Tab)this._myTabs.get(1));
        if (!this.isInit) {
            this._myApplet.registerPre((Object)this);
            this._myApplet.registerDraw((Object)this);
        }
        this.isInit = true;
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        this.controlP5.keyHandler.clear();
    }

    public Tab getCurrentTab() {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).isActive()) continue;
            return (Tab)this._myTabs.get(i);
        }
        return null;
    }

    public ControlWindow activateTab(String string) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).getName().equals(string)) continue;
            if (!((Tab)this._myTabs.get((int)i)).isActive) {
                this.resetMouseOver();
            }
            this.activateTab((Tab)this._myTabs.get(i));
        }
        return this;
    }

    public ControlWindow removeTab(Tab tab) {
        this._myTabs.remove(tab);
        return this;
    }

    public Tab add(Tab tab) {
        this._myTabs.add(tab);
        return tab;
    }

    public Tab addTab(String string) {
        return this.getTab(string);
    }

    protected ControlWindow activateTab(Tab tab) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (this._myTabs.get(i) == tab) {
                if (!((Tab)this._myTabs.get((int)i)).isActive) {
                    this.resetMouseOver();
                }
                ((Tab)this._myTabs.get(i)).setActive(true);
                continue;
            }
            ((Tab)this._myTabs.get(i)).setActive(false);
        }
        return this;
    }

    public ControllerList getTabs() {
        return this._myTabs;
    }

    public Tab getTab(String string) {
        return this.controlP5.getTab(this, string);
    }

    public ControlWindow setPositionOfTabs(PVector pVector) {
        this.positionOfTabs.set(pVector);
        return this;
    }

    public ControlWindow setPositionOfTabs(int n, int n2) {
        this.positionOfTabs.set((float)n, (float)n2, this.positionOfTabs.z);
        return this;
    }

    public PVector getPositionOfTabs() {
        return this.positionOfTabs;
    }

    void setAllignmentOfTabs(int n, int n2) {
    }

    void setAllignmentOfTabs(int n, int n2, int n3) {
    }

    void setAllignmentOfTabs(int n) {
    }

    public void remove() {
        for (int i = this._myTabs.size() - 1; i >= 0; --i) {
            ((Tab)this._myTabs.get(i)).remove();
        }
        this._myTabs.clear();
        this._myTabs.clearDrawable();
        this.controlP5.controlWindowList.remove(this);
    }

    public ControlWindow clear() {
        this.remove();
        if (this._myApplet instanceof PAppletWindow) {
            this._myApplet.unregisterMouseEvent((Object)this);
            this._myApplet.removeMouseWheelListener((MouseWheelListener)this);
            this._myApplet.stop();
            ((PAppletWindow)this._myApplet).dispose();
            this._myApplet = null;
            System.gc();
        }
        return this;
    }

    protected void updateFont(ControlFont controlFont) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).updateFont(controlFont);
        }
    }

    @ControlP5.Invisible
    public void updateEvents() {
        this.handleMouseOver();
        this.handleMouseWheelMoved();
        if (this._myTabs.size() <= 0) {
            return;
        }
        this._myTabs.get(0).updateEvents();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).continuousUpdateEvents();
            if (!((Tab)this._myTabs.get(i)).isActive() || !((Tab)this._myTabs.get(i)).isVisible()) continue;
            this._myTabs.get(i).updateEvents();
        }
    }

    public boolean isMouseOver() {
        if (this._myFrameCount + 1 < this._myApplet.frameCount) {
            this.resetMouseOver();
        }
        return this.isVisible ? this.isMouseOver : false;
    }

    public boolean isMouseOver(ControllerInterface<?> controllerInterface) {
        return this.mouseoverlist.contains(controllerInterface);
    }

    public void resetMouseOver() {
        this.isMouseOver = false;
        for (int i = this.mouseoverlist.size() - 1; i >= 0; --i) {
            this.mouseoverlist.get(i).setMouseOver(false);
        }
        this.mouseoverlist.clear();
    }

    public ControllerInterface<?> getFirstFromMouseOverList() {
        if (this.getMouseOverList().isEmpty()) {
            return null;
        }
        return this.getMouseOverList().get(0);
    }

    public List<ControllerInterface<?>> getMouseOverList() {
        return this.mouseoverlist;
    }

    private ControlWindow handleMouseOver() {
        for (int i = this.mouseoverlist.size() - 1; i >= 0; --i) {
            if (this.mouseoverlist.get(i).isMouseOver() && this.isVisible) continue;
            this.mouseoverlist.remove(i);
        }
        this.isMouseOver = this.mouseoverlist.size() > 0;
        return this;
    }

    public ControlWindow removeMouseOverFor(ControllerInterface<?> controllerInterface) {
        this.mouseoverlist.remove(controllerInterface);
        return this;
    }

    protected ControlWindow setMouseOverController(ControllerInterface<?> controllerInterface) {
        if (!this.mouseoverlist.contains(controllerInterface) && this.isVisible && controllerInterface.isVisible()) {
            this.mouseoverlist.add(controllerInterface);
        }
        this.isMouseOver = true;
        return this;
    }

    public void update() {
        this._myTabs.get(0).update();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).update();
        }
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).setUpdate(bl);
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public ControlWindow addCanvas(ControlWindowCanvas controlWindowCanvas) {
        this._myControlWindowCanvas.add(controlWindowCanvas);
        controlWindowCanvas.setControlWindow(this);
        controlWindowCanvas.setup(this._myApplet);
        return this;
    }

    public ControlWindow removeCanvas(ControlWindowCanvas controlWindowCanvas) {
        this._myControlWindowCanvas.remove(controlWindowCanvas);
        return this;
    }

    public ControlWindow pre() {
        if (this._myFrameCount + 1 < this._myApplet.frameCount) {
            if (this.isReset) {
                this.resetMouseOver();
                this.isReset = false;
            }
        } else {
            this.isReset = true;
        }
        if (this.isVisible && this.isPAppletWindow && this.isDrawBackground) {
            this._myApplet.background(this.background);
        }
        return this;
    }

    public ControlWindow smooth() {
        if (this.isPAppletWindow) {
            this._myApplet.smooth();
        }
        return this;
    }

    public ControlWindow noSmooth() {
        if (this.isPAppletWindow) {
            this._myApplet.noSmooth();
        }
        return this;
    }

    public void draw() {
        this._myFrameCount = this._myApplet.frameCount;
        if (!this.controlP5.blockDraw) {
            this.updateEvents();
            if (this.isVisible) {
                int n;
                int n2;
                int n3 = this._myApplet.g.rectMode;
                int n4 = this._myApplet.g.ellipseMode;
                int n5 = this._myApplet.g.imageMode;
                this._myApplet.pushStyle();
                this._myApplet.rectMode(0);
                this._myApplet.ellipseMode(0);
                this._myApplet.imageMode(0);
                this._myApplet.noStroke();
                if (this._myApplet instanceof PAppletWindow) {
                    this._myApplet.background(this.background);
                }
                if (this._myDrawable != null) {
                    this._myDrawable.draw(this._myApplet);
                }
                for (n2 = 0; n2 < this._myControlWindowCanvas.size(); ++n2) {
                    if (this._myControlWindowCanvas.get(n2).mode() != 0) continue;
                    this._myControlWindowCanvas.get(n2).draw(this._myApplet);
                }
                this._myApplet.noStroke();
                this._myApplet.noFill();
                n2 = (int)this.getPositionOfTabs().x;
                int n6 = (int)this.getPositionOfTabs().y;
                int n7 = 0;
                if (this._myTabs.size() > 0) {
                    for (n = 1; n < this._myTabs.size(); ++n) {
                        if (!((Tab)this._myTabs.get(n)).isVisible()) continue;
                        if (n7 < ((Tab)this._myTabs.get(n)).height()) {
                            n7 = ((Tab)this._myTabs.get(n)).height();
                        }
                        if (n2 > this.component().getWidth() - ((Tab)this._myTabs.get(n)).width()) {
                            n6 += n7 + 1;
                            n2 = (int)this.getPositionOfTabs().x;
                            n7 = 0;
                        }
                        ((Tab)this._myTabs.get(n)).setOffset(n2, n6);
                        if (((Tab)this._myTabs.get(n)).isActive()) {
                            ((Tab)this._myTabs.get(n)).draw(this._myApplet);
                        }
                        if (((Tab)this._myTabs.get(n)).updateLabel()) {
                            ((Tab)this._myTabs.get(n)).drawLabel(this._myApplet);
                        }
                        n2 += ((Tab)this._myTabs.get(n)).width();
                    }
                    this._myTabs.get(0).draw(this._myApplet);
                }
                for (n = 0; n < this._myControlWindowCanvas.size(); ++n) {
                    if (this._myControlWindowCanvas.get(n).mode() != 1) continue;
                    this._myControlWindowCanvas.get(n).draw(this._myApplet);
                }
                this.pmouseX = this.mouseX;
                this.pmouseY = this.mouseY;
                this.controlP5.getTooltip().draw(this);
                this._myApplet.rectMode(n3);
                this._myApplet.ellipseMode(n4);
                this._myApplet.imageMode(n5);
                this._myApplet.popStyle();
            }
        }
    }

    public ControlWindow setContext(CDrawable cDrawable) {
        this._myDrawable = cDrawable;
        return this;
    }

    public String name() {
        return this._myName;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (this.isMouse) {
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            if (mouseEvent.getID() == 501) {
                this.mousePressedEvent();
            }
            if (mouseEvent.getID() == 502) {
                this.mouseReleasedEvent();
            }
        }
    }

    private void mousePressedEvent() {
        if (this.isVisible) {
            this.mousePressed = true;
            for (int i = 0; i < this._myTabs.size(); ++i) {
                if (!this._myTabs.get(i).setMousePressed(true)) continue;
                this.mouselock = true;
                return;
            }
        }
    }

    private void mouseReleasedEvent() {
        if (this.isVisible) {
            this.mousePressed = false;
            this.mouselock = false;
            for (int i = 0; i < this._myTabs.size(); ++i) {
                this._myTabs.get(i).setMousePressed(false);
            }
        }
    }

    public ControlWindow disableMouseWheel() {
        this.mousewheel = false;
        return this;
    }

    public ControlWindow enableMouseWheel() {
        this.mousewheel = true;
        return this;
    }

    public boolean isMouseWheel() {
        return this.mousewheel;
    }

    @Override
    @ControlP5.Invisible
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.mousewheel && this.isMouseOver()) {
            this.mouseWheelMoved = mouseWheelEvent.getWheelRotation();
        }
    }

    private void handleMouseWheelMoved() {
        if (this.mouseWheelMoved != 0) {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList(this.mouseoverlist);
            for (ControllerInterface<?> controllerInterface : copyOnWriteArrayList) {
                if (!controllerInterface.isVisible()) continue;
                if (controllerInterface instanceof Controller) {
                    ((Controller)controllerInterface).onScroll(this.mouseWheelMoved);
                }
                if (controllerInterface instanceof ControllerGroup) {
                    ((ControllerGroup)controllerInterface).onScroll(this.mouseWheelMoved);
                }
                if (controllerInterface instanceof Slider) {
                    ((Slider)controllerInterface).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (controllerInterface instanceof Knob) {
                    ((Knob)controllerInterface).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (controllerInterface instanceof Numberbox) {
                    ((Numberbox)controllerInterface).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (controllerInterface instanceof ListBox) {
                    ((ListBox)controllerInterface).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (controllerInterface instanceof DropdownList) {
                    ((DropdownList)controllerInterface).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (!(controllerInterface instanceof Textarea)) break;
                ((Textarea)controllerInterface).scrolled(this.mouseWheelMoved);
                break;
            }
        }
        this.mouseWheelMoved = 0;
    }

    @ControlP5.Invisible
    public void multitouch(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            this.mouseX = nArray[i][0];
            this.mouseY = nArray[i][1];
            if (!this.isVisible) continue;
            if (nArray[i][2] == 501) {
                this.mousePressed = true;
                for (n = 0; n < this._myTabs.size(); ++n) {
                    if (!this._myTabs.get(n).setMousePressed(true)) continue;
                    this.mouselock = true;
                    ControlP5.logger().finer(" mouselock = " + this.mouselock);
                    return;
                }
            }
            if (nArray[i][2] != 502) continue;
            this.mousePressed = false;
            this.mouselock = false;
            for (n = 0; n < this._myTabs.size(); ++n) {
                this._myTabs.get(n).setMousePressed(false);
            }
        }
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    public void keyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).keyEvent(keyEvent);
        }
    }

    public ControlWindow setColorActive(int n) {
        this.color.setActive(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorActive(n);
        }
        return this;
    }

    public ControlWindow setColorForeground(int n) {
        this.color.setForeground(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorForeground(n);
        }
        return this;
    }

    public ControlWindow setColorBackground(int n) {
        this.color.setBackground(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorBackground(n);
        }
        return this;
    }

    public ControlWindow setColorLabel(int n) {
        this.color.setCaptionLabel(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorLabel(n);
        }
        return this;
    }

    public ControlWindow setColorValue(int n) {
        this.color.setValueLabel(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorValue(n);
        }
        return this;
    }

    public ControlWindow setBackground(int n) {
        this.background = n;
        return this;
    }

    public PApplet papplet() {
        return this._myApplet;
    }

    public Component component() {
        return this.papplet();
    }

    public ControlWindow setTitle(String string) {
        if (this._myApplet instanceof PAppletWindow) {
            ((PAppletWindow)this._myApplet).setTitle(string);
        }
        return this;
    }

    public ControlWindow showCoordinates() {
        if (this._myApplet instanceof PAppletWindow) {
            ((PAppletWindow)this._myApplet).showCoordinates();
        }
        return this;
    }

    public ControlWindow hideCoordinates() {
        if (this._myApplet instanceof PAppletWindow) {
            ((PAppletWindow)this._myApplet).hideCoordinates();
        }
        return this;
    }

    public ControlWindow hide() {
        this.isVisible = false;
        this.isMouseOver = false;
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).visible(false);
        }
        return this;
    }

    public ControlWindow setUpdateMode(int n) {
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).setMode(n);
        }
        return this;
    }

    public ControlWindow frameRate(int n) {
        this._myApplet.frameRate((float)n);
        return this;
    }

    public ControlWindow show() {
        this.isVisible = true;
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).visible(true);
        }
        return this;
    }

    public ControlWindow setDrawBackground(boolean bl) {
        this.isDrawBackground = bl;
        return this;
    }

    public boolean isDrawBackground() {
        return this.isDrawBackground;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected boolean isControllerActive(Controller<?> controller) {
        if (this.isControllerActive == null) {
            return false;
        }
        return this.isControllerActive.equals(controller);
    }

    protected ControlWindow setControllerActive(Controller<?> controller) {
        this.isControllerActive = controller;
        return this;
    }

    public ControlWindow toggleUndecorated() {
        this.setUndecorated(!this.isUndecorated());
        return this;
    }

    public ControlWindow setUndecorated(boolean bl) {
        if (bl != this.isUndecorated()) {
            this.isUndecorated = bl;
            this._myApplet.frame.removeNotify();
            this._myApplet.frame.setUndecorated(this.isUndecorated);
            this._myApplet.setSize(this._myApplet.width, this._myApplet.height);
            this._myApplet.setBounds(0, 0, this._myApplet.width, this._myApplet.height);
            this._myApplet.frame.setSize(this._myApplet.width, this._myApplet.height);
            this._myApplet.frame.addNotify();
        }
        return this;
    }

    public Frame getFrame() {
        return this._myApplet.frame;
    }

    public boolean isUndecorated() {
        return this.isUndecorated;
    }

    public ControlWindow setPosition(int n, int n2) {
        return this.setLocation(n, n2);
    }

    public ControlWindow setLocation(int n, int n2) {
        this._myApplet.frame.setLocation(n, n2);
        return this;
    }

    public Pointer getPointer() {
        return this._myPointer;
    }

    public ControlWindow disablePointer() {
        this._myPointer.disable();
        return this;
    }

    public ControlWindow enablePointer() {
        this._myPointer.enable();
        return this;
    }

    @Deprecated
    public ControllerList tabs() {
        return this._myTabs;
    }

    @Deprecated
    public Tab tab(String string) {
        return this.controlP5.getTab(this, string);
    }

    @Deprecated
    public Tab currentTab() {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).isActive()) continue;
            return (Tab)this._myTabs.get(i);
        }
        return null;
    }

    @Deprecated
    public void setMode(int n) {
        this.setUpdateMode(n);
    }

    public class Pointer {
        public Pointer setX(int n) {
            ControlWindow.this.mouseX = n;
            return this;
        }

        public Pointer setY(int n) {
            ControlWindow.this.mouseY = n;
            return this;
        }

        public int getY() {
            return ControlWindow.this.mouseY;
        }

        public int getX() {
            return ControlWindow.this.mouseX;
        }

        public int getPreviousX() {
            return ControlWindow.this.pmouseX;
        }

        public int getPreviousY() {
            return ControlWindow.this.pmouseY;
        }

        public Pointer set(int n, int n2) {
            this.setX(n);
            this.setY(n2);
            return this;
        }

        public Pointer pressed() {
            ControlWindow.this.mousePressedEvent();
            return this;
        }

        public Pointer released() {
            ControlWindow.this.mouseReleasedEvent();
            return this;
        }

        public void enable() {
            ControlWindow.this.isMouse = false;
        }

        public void disable() {
            ControlWindow.this.isMouse = true;
        }

        public boolean isEnabled() {
            return !ControlWindow.this.isMouse;
        }
    }
}

