/*
 * errno.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef errno_h
#define errno_h


#ifndef ASM_FILE


#ifdef DEBUG
#define PRINT_ERR(error) print_error(error)
#else
#define PRINT_ERR(error) (-error)
#endif


/*
 * error number
 * ϡerror.cerror_str[]碌ƹ롣
 */
enum{
	NOERR,
	/*
	 * POSIX error number
	 */
	EAGAIN,			/* Try again */
	EDEADLK,		/* Resource deadlock would occur */
	ENOLCK,			/* No locks available */
	ENOTTY,			/* The file is not a terminal */
	EPERM,			/* Operation not permitted */
	EPIPE,			/* Broken pipe */
	EDOM,			/* Math argument out of domain of func */
	ERANGE,			/* Math result is too large */

	/* Memory error */
	ENOMEM,			/* Cannot allocate memory */
	EFAULT,			/* Bad address */

	/* Function error */
	EINTR,			/* Function was interrupted by a signal */
	EINVAL,			/* Invalid argument */
	E2BIG,			/* Arg list too long */
	ENOSYS,			/* Function not implemented */

	/* Process error */
	ECHILD,			/* No child processes */
	ESRCH,			/* No such process */

	/* File system error */
	EACCES,			/* Search permission denied */
	ENOTEMPTY,		/* Directory not empty */
	ENOEXEC,		/* Exec format error */
	EBADF,			/* Bad file descriptor */
	EBUSY,			/* The directory is in use */
	EEXIST,			/* The named file already exists */
	EFBIG,			/* File size too large */
	EISDIR,			/* Is a directory */
	ENOTDIR,		/* Not a directory */
	EMFILE,			/* Too many file descriptors in this process */
	EMLINK,			/* Too many links */
	ENAMETOOLONG,	/* File name too long */
	ENFILE,			/* Too many files opened in the system */
	ENOENT,			/* No such file or directory */
	EROFS,			/* Read-only file system */
	ESPIPE,			/* Illegal seek */
	EXDEV,			/* Link file is another file system */

	/* Device error */
	EIO,			/* IO error */
	ENODEV,			/* No such device */
	ENXIO,			/* Device not ready */
	ENOSPC,			/* No space left on device */

	/*
	 * Option error number
	 */
	EDBUSY,			/* Device busy */
	EDERRE,			/* Device error */
	ENOMEDIUM,		/* No medium in removable device */
	EMDEV,			/* Too many device in the system */
	ENOTIMER,		/* ޡʤ */
	ETIMEOUT,		/* ޡॢ */
};


extern int print_error(int);


#endif


#endif
