/*
 * mm.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꡼ץ
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"lock.h"
#include"interrupt.h"
#include"proc.h"
#include"mp.h"
#include"segment.h"
#include"errno.h"
#include"mm.h"
#include"device.h"
/****************************/
extern void test_program();
/*****************************/


enum{
	PAGE_NUM=0x400,				/* Number of pages in a table or a directory */
	MAX_REF_PAGE_STORE=255,		/* Max refrence counts of page store */
	HEAP_NUM=11,				/* kmallocMEM¤κ */

	INT_BIT=sizeof(int)*8,		/* Number of integer bit */

	HASH_NUM=CACHE_NUM/2,		/* Number of cache hash table */
	SECTER_SIZE=512
};


/*
 * ʪ꡼ơ֥link struct
 * page tableprocessݻ
 */
typedef struct PAGE_TABLE_ADDR{
	uint *page_table;
	PROC *proc;
	struct PAGE_TABLE_ADDR *next;
}PAGE_TABLE_ADDR;

/*
 * ʪ꡼ơ֥빽¤
 * Page
 */
typedef struct PHYSICAL_PAGE{
	ushort ref_count;					/* reference count */
	ushort heap_num;					/* Heap number */
	PAGE_TABLE_ADDR *page_table_addr;	/* Link of page table address struct */
	struct PHYSICAL_PAGE *next;
	struct PHYSICAL_PAGE *prev;
}PHYSICAL_PAGE;

typedef struct FREE{
	char* last;
	struct FREE *prev;
	struct FREE *next;
}FREE;

typedef struct{
	uint size;
	FREE *free;
	int gate;
}HEAP;

typedef struct CACHE_TABLE{
	struct CACHE_TABLE *hnext;	/* Hash next */
	struct CACHE_TABLE *hprev;	/* Hash previous */
	void *addr;					/* Cache address */
	int dev;					/* Device number */
	uint block;					/* Device block index */
	struct CACHE_TABLE *next;	/* Cache chain next */
	struct CACHE_TABLE *prev;	/* Cache chain previous */
	WAIT_QUEUE wait_queue;		/* Wait queue */
}CACHE_TABLE;


/* ꡼setup.S */
uint all_memory_size;

/* Kernel page directory */
/*static uint *idle_pagedir=NULL;*/

/* ꡼ơ֥ */
static PHYSICAL_PAGE *kernel_free_top=NULL;					/* ֶͥʪ꡼󥯥ȥå */
static PHYSICAL_PAGE *user_free_top=NULL;					/* 桼ֶʪ꡼󥯥ȥå */
static PHYSICAL_PAGE kernel_realloc_new={0,0,NULL,NULL};	/* ֻͥʲġʪ꡼󥯺ǿ */
static PHYSICAL_PAGE kernel_realloc_old={0,0,NULL,NULL};	/* ֻͥʲġʪ꡼󥯺Ǹ */
static PHYSICAL_PAGE user_realloc_new={0,0,NULL,NULL};		/* 桼ֻʲġʪ꡼󥯺ǿ */
static PHYSICAL_PAGE user_realloc_old={0,0,NULL,NULL};		/* 桼ֻʲġʪ꡼󥯺Ǹ */
static int page_alloc_gate=0;								/* PHYSICAL_PAGE lock gate */

/* kfreeʼ */
static FREE guard[HEAP_NUM];

/* kmallocѹ¤ */
static HEAP heap[]={
	{0,NULL,0},
	{0x8,   &guard[1], 0},
	{0x10,  &guard[2], 0},
	{0x20,  &guard[3], 0},
	{0x40,  &guard[4], 0},
	{0x80,  &guard[5], 0},
	{0x100, &guard[6], 0},
	{0x200, &guard[7], 0},
	{0x400, &guard[8], 0},
	{0x800, &guard[9], 0},
	{0x1000,&guard[10],0}
};

/* Page store table */
static size_t page_store_size=0;			/* Page store size */
static uchar *page_store_ref_table=NULL;	/* For refrence */
static uint *page_store_use_table=NULL;		/* For search */
static int unuse_store_table=0;				/* Unuse store table number */
static int page_sotre_gate=0;				/* Lock gate for page store handling */

/* Cache */
static CACHE_TABLE cache_tbl[CACHE_NUM];			/* Cache table */
static CACHE_TABLE *cache_hash[HASH_NUM];			/* Hash table for searching cache table */
static CACHE_TABLE *cache_tbl_old=&cache_tbl[0];	/* Cache table old point */
static int cache_tbl_gate=0;						/* Lock gate */


static void *alloc_kernel_pagemem();
static void *alloc_user_pagemem();
static void free_pagemem(void*);
static int buckup_used_page(void*);


/*
 * Physical addressPHYSICAL_PAGE address֤
 * parameters : Physical address
 * return : PHYSICAL_PAGE address
 */
extern inline PHYSICAL_PAGE *get_physpage_from_addr(void *addr)
{
	return (PHYSICAL_PAGE*)((uint)addr/PAGE_SIZE*sizeof(PHYSICAL_PAGE)+PHYSICAL_PAGE_TABLE_ADDR);
}


/*
 * PHYSICAL_PAGE addressPhysical addres֤
 * parameters : PHYSICAL_PAGE address
 * return : Physical address
 */
extern inline void *get_addr_from_physpage(PHYSICAL_PAGE *memtable)
{
	return (void*)(((uint)memtable-PHYSICAL_PAGE_TABLE_ADDR)/sizeof(PHYSICAL_PAGE)*PAGE_SIZE);
}


/*
 * Page tableread write flag򥯥ꥢ
 * parameters : Page table address
 */
extern inline void clear_rwflag(uint *page)
{
	int i;


	for(i=0;i<PAGE_SIZE/sizeof(uint);++i)page[i]&=0xfffffffd;
}


/*
 * page_store_use_tableγbitޡ
 * parameters : Number
 */
extern inline void mark_page_store_use(int num)
{
	page_store_use_table[num/INT_BIT]|=1<<num%INT_BIT;
}


/*
 * page_store_use_tableγbit򥯥ꥢ
 * parameters : Number
 */
extern inline void clear_page_store_use(int num)
{
	page_store_use_table[num/INT_BIT]&=~(1<<num%INT_BIT);
}


/*
 * Find size of all physical memory
 */
uint find_all_memsize()
{
	enum{EXIST_MEM_SIZE=0x800000};		/* ꡼¬ñ */

	uint volatile *point;


	/* ꡼ñ̤Ȥ¬ꤹ*/
	for(point=(uint*)EXIST_MEM_SIZE-1;;point+=EXIST_MEM_SIZE/sizeof(uint))
	{
		*point=0x5a5a5a5a;
		if(*point!=0x5a5a5a5a)break;
		else
		{
			*point=0xf0f0f0f0;
			if(*point!=0xf0f0f0f0)break;
		}
	}

	return (all_memory_size=(uint)point-EXIST_MEM_SIZE+sizeof(uint));
}


/***********************************************************************************
 *
 * ꡼ؿ
 *
 ***********************************************************************************/


/*
 * ʪ꡼ơ֥
 */
void init_physical_page_table()
{
	int i,last;
	PHYSICAL_PAGE *p;


	p=(PHYSICAL_PAGE*)PHYSICAL_PAGE_TABLE_ADDR;

	/* ǽ1Mbyteʬ꡼Ƥ0 */
	memset(p,0,0x100000/PAGE_SIZE*sizeof(PHYSICAL_PAGE));

	/* Ĥե꡼ꤹ */
	i=0x100000/PAGE_SIZE;
	kernel_free_top=&p[i];
	for(last=all_memory_size/PAGE_SIZE;i<last;++i)
	{
		p[i].ref_count=0;
		p[i].heap_num=0;
		p[i].page_table_addr=NULL;
		p[i].next=&p[i+1];
		p[i].prev=NULL;
	}
	p[i-1].next=NULL;

	if(all_memory_size>BEGIN_USER)
	{
		user_free_top=(PHYSICAL_PAGE*)PHYSICAL_PAGE_TABLE_ADDR+(BEGIN_USER/PAGE_SIZE);
		(user_free_top-1)->next=NULL;
	}

	/* ꡼ơ֥ʬ꡼ƤʲԲġ */
	i=PHYSICAL_PAGE_TABLE_ADDR/PAGE_SIZE;
	last=ROUNDUP(PHYSICAL_PAGE_TABLE_ADDR+all_memory_size/PAGE_SIZE*sizeof(PHYSICAL_PAGE),PAGE_SIZE)/PAGE_SIZE;
	if(&p[i]==kernel_free_top)kernel_free_top=&p[last];
	else p[i-1].next=&p[last];

	/* Used link */
	kernel_realloc_new.next=&kernel_realloc_old;
	kernel_realloc_old.prev=&kernel_realloc_new;
	user_realloc_new.next=&user_realloc_old;
	user_realloc_old.prev=&user_realloc_new;
}


/*
 * ֤ͥإե꡼ʪڡƤ
 * ƤڡϲԲ
 * return : Allocate addres or NULL
 */
void *alloc_kernel_pagemem()
{
	void *address;
	bool used=0;


	enter_spinlock(&page_alloc_gate);
	{
		if(kernel_free_top!=NULL)
		{
			kernel_free_top->ref_count=1;

			address=(void*)get_addr_from_physpage(kernel_free_top);
			kernel_free_top->prev=NULL;				/* Used linkʤȤNULLꤹ */
			kernel_free_top=kernel_free_top->next;
		}
		else if(kernel_realloc_old.prev!=&kernel_realloc_new)
		{
			kernel_realloc_old.prev->ref_count=1;

			address=(void*)get_addr_from_physpage(kernel_realloc_old.prev);
			kernel_realloc_old.prev=kernel_realloc_old.prev->prev;
			kernel_realloc_old.prev->next->prev=NULL;
			kernel_realloc_old.prev->next=&kernel_realloc_old;
			used=1;
		}
		else address=NULL;
	}
	exit_spinlock(&page_alloc_gate);

	/* ꡼Ƥback up */
	if(used&&(buckup_used_page(address)==-1))return NULL;

	return address;
}


/*
 * 桼֤إե꡼ʪڡƤ
 * Ƥڡϲ
 * return : Allocate addres or NULL
 */
void *alloc_user_pagemem()
{
	void *address;
	PHYSICAL_PAGE *alloc;
	int used=0;


	enter_spinlock(&page_alloc_gate);
	{
		if(user_free_top!=NULL)
		{
			alloc=user_free_top;
			address=(void*)get_addr_from_physpage(alloc);
			user_free_top=alloc->next;

			alloc->ref_count=1;

			/* Used link˲ä */
			alloc->next=user_realloc_new.next;
			alloc->prev=&user_realloc_new;
			user_realloc_new.next=alloc;
			alloc->next->prev=alloc;
		}
		else if(kernel_free_top!=NULL)
		{
			alloc=kernel_free_top;
			address=(void*)get_addr_from_physpage(alloc);
			kernel_free_top=alloc->next;

			alloc->ref_count=1;

			/* Used link˲ä */
			alloc->next=kernel_realloc_new.next;
			alloc->prev=&kernel_realloc_new;
			kernel_realloc_new.next=alloc;
			alloc->next->prev=alloc;
		}
		else if(user_realloc_old.prev!=&user_realloc_new)
		{
			alloc=user_realloc_old.prev;
			address=(void*)get_addr_from_physpage(alloc);

			user_realloc_old.prev=user_realloc_old.prev->prev;
			user_realloc_old.prev->next=&user_realloc_old;

			alloc->ref_count=1;

			/* Used linkǿ˲ä */
			alloc->next=user_realloc_new.next;
			alloc->prev=&user_realloc_new;
			user_realloc_new.next=alloc;
			alloc->next->prev=alloc;

			used=1;

		}
		else if(kernel_realloc_old.prev!=&kernel_realloc_new)
		{
			alloc=kernel_realloc_old.prev;
			address=(void*)get_addr_from_physpage(alloc);

			kernel_realloc_old.prev=kernel_realloc_old.prev->prev;
			kernel_realloc_old.prev->next=&kernel_realloc_old;

			alloc->ref_count=1;

			/* Used linkǿ˲ä */
			alloc->next=kernel_realloc_new.next;
			alloc->prev=&kernel_realloc_new;
			kernel_realloc_new.next=alloc;
			alloc->next->prev=alloc;

			used=1;
		}
		else address=NULL;
	}
	exit_spinlock(&page_alloc_gate);

	/* ꡼Ƥback up */
	if(used&&(buckup_used_page(address)==-1))return NULL;

	return address;
}


/*
 * Free page or decrement reference count
 * parameters : address
 */
void free_pagemem(void *addr)
{
	PROC *proc;
	PHYSICAL_PAGE *p;
	PAGE_TABLE_ADDR *q=NULL,**r;


	p=get_physpage_from_addr(addr);

	enter_spinlock(&page_alloc_gate);
	{
		/* ˻ȤƤʤޤϳԲĤΥڡ */
		if(p->ref_count==0)goto EXIT;

		if(--p->ref_count==0)
		{
			if(addr<(void*)END_KERNEL)
			{
				/* Kernel free link */
				p->next=kernel_free_top;
				kernel_free_top=p;
			}
			else
			{
				/* User free link˲ä */
				p->next=user_free_top;
				user_free_top=p;
			}
			/* Used link */
			if(p->prev!=NULL)
			{
				p->prev->next=p->next;
				p->next->prev=p->prev;
			}
			p->heap_num=0;
			q=p->page_table_addr;
			p->page_table_addr=NULL;
		}
		else
		{
			/* Page table address link */
			proc=cputask[get_current_cpu()].current_task;
			for(q=p->page_table_addr,r=&p->page_table_addr;;r=&q->next,q=q->next)
				if(q->proc==proc)*r=q->next;
		}
	}
EXIT:
	exit_spinlock(&page_alloc_gate);

	kfree(q);
}


/*
 * 2Ѿ襵Ȥ˥ڡ꡼ʬ䤹
 * ϥڡ
 * parameters : Size by byte
 * return : address
 */
void *kmalloc(size_t size)
{
	char *addr=NULL;
	int i;


	if((size==0)||(size>PAGE_SIZE))return NULL;		/* Require size is over */

	for(i=1;size>heap[i].size;++i);					/* Require size=heap[i].size */

	enter_spinlock(&heap[i].gate);
	{
		if(heap[i].free==&guard[i])
		{
			if((heap[i].free=(FREE*)alloc_kernel_pagemem())==NULL)goto OUT;

			/*
			 * Ȥaddress狼褦ˤ
			 */
			get_physpage_from_addr((void*)heap[i].free)->heap_num=i;

			heap[i].free->prev=&guard[i];
			heap[i].free->next=&guard[i];
			guard[i].prev=heap[i].free;
			guard[i].next=heap[i].free;
			heap[i].free->last=(char*)heap[i].free+PAGE_SIZE;
		}

		addr=(char*)heap[i].free->last-heap[i].size;

		if(heap[i].free==(FREE*)addr)
		{
			heap[i].free=((FREE*)addr)->next;
			((FREE*)addr)->prev->next=((FREE*)addr)->next;
			((FREE*)addr)->next->prev=((FREE*)addr)->prev;
		}
		else heap[i].free->last=addr;
	}
OUT:
	exit_spinlock(&heap[i].gate);

	return addr;
}


/*
 * ꡼
 * parameters : Address
 */
void kfree(void *ptr)
{
	uint i;
	FREE *p,*end;


	if(ptr==NULL)return;

	if((i=(int)get_physpage_from_addr(ptr)->heap_num)==0)return;

	enter_spinlock(&heap[i].gate);
	{
		/* Free linkϾ */
		for(p=heap[i].free;p!=&guard[i];p=p->next)
			if(p>(FREE*)ptr)break;

		/* Link */
		p->prev->next=(FREE*)ptr;
		((FREE*)ptr)->prev=p->prev;
		((FREE*)ptr)->next=p;
		((FREE*)ptr)->last=(char*)ptr+heap[i].size;
		p->prev=(FREE*)ptr;

		/* ɥ쥹³ƤХ꡼Ĥʤ */
		end=((FREE*)ptr)->prev;
		do
		{
			p=p->prev;

			if(p->last==(char*)p->next)
			{
				p->last=p->next->last;
				p->next=p->next->next;
			}

			/* ꡼PAGE_SIZEʤڡ */
			if(!((uint)p&PAGE_BOUND)&&(p->last>=(char*)p+PAGE_SIZE))
			{
				if(p->last>(char*)p+PAGE_SIZE)
				{
					p->prev->next=(FREE*)((char*)p+PAGE_SIZE);
					p->prev->next->next=p->next;
					p->prev->next->prev=p->prev;
					p->prev->next->last=p->last;
					p->next->prev=p->prev->next;
				}
				else
				{
					p->prev->next=p->next;
					p->next->prev=p->prev;
				}
				free_pagemem(p);
				break;
			}

		}while(p!=end);

		/* Free memory link Ƭ */
		heap[i].free=guard[i].next;
	}
	exit_spinlock(&heap[i].gate);
}


/***********************************************************************************
 *
 * ڡ󥰴ؿ
 *
 ***********************************************************************************/


/*
 * ͥڡơ֥ꤹ
 * return : Page directory or NULL
 */
uint *init_idle_page()
{
	void *stack;
	uint *idle_pagedir,*pagetable;
	uint i;


	/* ͥڡǥ쥯ȥ */
	if((idle_pagedir=(uint*)alloc_kernel_pagemem())==NULL)return NULL;
	memset(idle_pagedir,0,PAGE_SIZE);
	for(i=0;i<BEGIN_KERNEL_STACK/PAGEDIR_ALLOC_SIZE;++i)
		idle_pagedir[i]=i*PAGEDIR_ALLOC_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M;

	/* ͥ륹åڡƤ */
	if((pagetable=(uint*)alloc_kernel_pagemem())==NULL)return NULL;
	memset(pagetable,0,PAGE_SIZE);
	idle_pagedir[BEGIN_KERNEL_STACK/PAGEDIR_ALLOC_SIZE]=(uint)pagetable|PAGE_PRESEN|PAGE_RW;
	if((stack=alloc_kernel_pagemem())==NULL)return NULL;
	pagetable[1023]=(uint)stack|PAGE_PRESEN|PAGE_RW;

	/* ꡼ޥåץIOڡѥǥ쥯ȥ */
	for(i=BEGIN_IOMAP/PAGEDIR_ALLOC_SIZE;i<1024;++i)
	   	idle_pagedir[i]=i*PAGEDIR_ALLOC_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M|PAGE_CASH_DISABLE;

	/* ڡ󥰳 */
	asm volatile(
			"movl	%%eax,%%cr3\n"			/* Set page directory address */
			"movl	$0x10,%%eax\n"
			"movl	%%eax,%%cr4\n"			/* 4Mڡĥ */
			"movl	%%cr0,%%eax\n"
			"orl		$0x80010000,%%eax\n"	/* Enable paging,Enable wp(ѡХν񤭹ݸ) */
			"movl	%%eax,%%cr0\n"
			"jmp		1f\n"
		"1:"
		::"a"(idle_pagedir)
	);

	return idle_pagedir;
}


/*
 * paging¸ν
 * Ȥκ255
 * parameters : ¸device file̾
 * return : 0 or Error number
 */
int init_page_backstore(char *path)
{
	enum{BYTE_BIT=8};

	int i,last;
	PHYSICAL_PAGE *p,*q,*r,*beg,*befo;


	/* device饵 */
	page_store_size=0x4000000;

	/* ȥѥơ֥Ϣ³ΰǳƤʲԲġ */
	last=ROUNDUP(page_store_size/PAGE_SIZE,PAGE_SIZE)/PAGE_SIZE;
	for(p=kernel_free_top,befo=NULL;;befo=r)
	{
		beg=p;
		if(p==NULL)return -ENOMEM;
		for(i=0,q=p;p==q;r=p,p=p->next,++q)
			if(++i==last)goto EXIT1;
	}
EXIT1:
	if(befo==NULL)kernel_free_top=p->next;
	else befo->next=p->next;
	page_store_ref_table=get_addr_from_physpage(beg);
	memset(page_store_ref_table,0,last*PAGE_SIZE);

	/* ѥơ֥Ϣ³ΰǳƤʲԲġ */
	last=ROUNDUP(page_store_size/PAGE_SIZE/BYTE_BIT,PAGE_SIZE)/PAGE_SIZE;
	for(p=kernel_free_top,befo=NULL;;befo=r)
	{
		beg=p;
		if(p==NULL)return -ENOMEM;
		for(i=0,q=p;p==q;r=p,p=p->next,++q)
			if(++i==last)goto EXIT2;
	}
EXIT2:
	if(befo==NULL)kernel_free_top=p->next;
	else befo->next=p->next;
	page_store_use_table=get_addr_from_physpage(beg);
	memset(page_store_use_table,0,last*PAGE_SIZE);

	return 0;
}


/*
 * Except of page fault
 * parameters : Exception frame
 */
void page_fault(EXCEPT_FRAME frame)
{

}


/*
 * Buck up used page into page store device
 * parameters : physical address
 * returns : 0 or Error number
 */
int buckup_used_page(void *addr)
{
	PHYSICAL_PAGE *phys_page;
	PAGE_TABLE_ADDR *p,*beg;
	int store_num;
	int cpu;
	int i,j,last;


	phys_page=get_physpage_from_addr(addr);
	cpu=get_current_cpu();

	if((beg=phys_page->page_table_addr)==NULL)return -ENOMEM;
	p=beg;
	do
	{
		/* page tableԺߤ */
		enter_spinlock(&p->proc->pagedir_gate);
		{
			*p->page_table&=~PAGE_PRESEN;
		}
		exit_spinlock(&p->proc->pagedir_gate);

		/* process¹ʤpage tableTBLեå夹 */
		if((p->proc->cpu!=cpu)&&(cputask[p->proc->cpu].current_task==p->proc))
			issue_interrupt_to_cpu(p->proc->cpu,FLASH_PAGEDIR_VECT);
	}while((p=p->next)!=beg);

	/* Search store space from page_store_use_table */
	last=page_store_size/PAGE_SIZE/INT_BIT;
	enter_spinlock(&page_sotre_gate);
	{
		for(i=unuse_store_table;page_store_use_table[i]!=~0;)
		{
			if(++i>=last)i=0;
			if(i==unuse_store_table)
			{
				exit_spinlock(&page_sotre_gate);
				return -ENOMEM;
			}
		}
		for(j=0;page_store_use_table[i]&(1<<j);++j);
		page_store_use_table[i]|=(1<<j);
		store_num=i*INT_BIT+j;

		unuse_store_table=i;
	}
	exit_spinlock(&page_sotre_gate);

	/* Store page to store device */
	/* ??????????????????????????? */

	return 0;
}


/*
 * Set pagetable
 * parameters : Load page address,Sorce page address,Page flag,Load process
 * return : 0 or Error number
 */
int load_user_page(void *dist,int flag,PROC *proc)
{
	void *page;
	uint *pagetable;
	PAGE_TABLE_ADDR *ptaddr;
	PHYSICAL_PAGE *phypage;


	enter_spinlock(&proc->pagedir_gate);
	{
		pagetable=(uint*)proc->pagedir[(uint)dist/PAGEDIR_ALLOC_SIZE];

	    if(pagetable==0)
	    {
	    	/* page tableƤ */
	    	if((pagetable=(uint*)alloc_kernel_pagemem())==NULL)goto ERROR;
	    	memset(pagetable,0,PAGE_SIZE);
	    	proc->pagedir[(uint)dist/PAGEDIR_ALLOC_SIZE]=(uint)pagetable|PAGE_PRESEN|PAGE_USER|PAGE_RW;
	    }
	    else pagetable=(uint*)((uint)pagetable&PAGE_ROUNDDOWN);

		/* pageƤ */
		if((page=alloc_user_pagemem())==NULL)goto ERROR;
		pagetable[((uint)dist&(PAGEDIR_ALLOC_SIZE-1))/PAGE_SIZE]=(uint)page|PAGE_PRESEN|PAGE_USER|flag;

		/* PAGE_TABLE_ADDR˲ä */
		if((ptaddr=kmalloc(sizeof(PAGE_TABLE_ADDR)))==NULL)goto ERROR;
		ptaddr->page_table=&pagetable[((uint)dist&(PAGEDIR_ALLOC_SIZE-1))/PAGE_SIZE];
		ptaddr->proc=proc;
		phypage=get_physpage_from_addr(page);
		ptaddr->next=phypage->page_table_addr;
		phypage->page_table_addr=ptaddr;
	}
	exit_spinlock(&proc->pagedir_gate);

	return 0;

ERROR:
	exit_spinlock(&proc->pagedir_gate);

	return -ENOMEM;
}


/*
 * page table
 * text sectionstackʳdata section롣user stack1pageĤƳ롣
 * parameters : process
 */
void free_user_page(PROC *proc)
{
	uint *page;
	int i,j;


	enter_spinlock(&proc->pagedir_gate);
	{
		/* user stackκǽpageĤƳ */
		page=(uint*)(proc->pagedir[BEGIN_USER_STACK/PAGEDIR_ALLOC_SIZE]&PAGE_ROUNDDOWN);
	    for(j=0;j<PAGE_SIZE/sizeof(uint)-1;++j)
	    {
	    	if(page[j]==0)continue;
	    	else if(page[j]&PAGE_PRESEN)
	    		free_pagemem((void*)page[j]);
			else
			{
				if(--page_store_ref_table[page[j]>>1]==0)
					clear_page_store_use(page[j]>>1);
			}

			page[j]=0;
		}

		/* Ĥuser page򤹤٤Ƴ */
		for(i=BEGIN_USER/PAGEDIR_ALLOC_SIZE;i<BEGIN_USER_STACK/PAGEDIR_ALLOC_SIZE;++i)
	    	if(proc->pagedir[i]&PAGE_PRESEN)
	    	{
	    		page=(uint*)(proc->pagedir[i]&PAGE_ROUNDDOWN);
	    		for(j=0;j<PAGE_SIZE/sizeof(uint);++j)
	    		{
	    			if(page[j]==0)continue;
	    			else if(page[j]&PAGE_PRESEN)free_pagemem((void*)page[j]);
					else
					{
						if(--page_store_ref_table[page[j]>>1]==0)
							clear_page_store_use(page[j]>>1);
					}
				}

				/* page table */
				free_pagemem(page);

				/* page direstory0ꥢ */
				proc->pagedir[i]=0;
			}
	}
	exit_spinlock(&proc->pagedir_gate);
}


/***********************************************************************************
 *
 * IOåѴؿ
 *
 ***********************************************************************************/

#ifdef IO_CASH
/*
 * Init cache
 * return : 0 or Error number
 */
int init_cache()
{
	int i;


	/* Init cache address */
	for(i=0;i<CACHE_NUM;++i)
	{
		if((cache_tbl[i].addr=alloc_kernel_pagemem())==NULL)return -ENOMEM;
		cache_tbl[i].next=&cache_tbl[i+1];
		cache_tbl[i].prev=&cache_tbl[i-1];
		cache_tbl[i].hprev=&cache_tbl[i];
		cache_tbl[i].hnext=NULL;
		cache_tbl[i].wait_queue.gate=0;
		cache_tbl[i].wait_queue.flag=0;
		cache_tbl[i].wait_queue.wait_next=(PROC*)&cache_tbl[i].wait_queue;
		cache_tbl[i].wait_queue.wait_prev=NULL;
	}
	cache_tbl[CACHE_NUM-1].next=&cache_tbl[0];
	cache_tbl[0].prev=&cache_tbl[CACHE_NUM-1];

	/* Init hash table */
	for(i=0;i<CACHE_NUM/2;++i)cache_hash[i]=NULL;

	return 0;
}


/*
 * Read from cache
 * parameters : Device number,Device block
 * return : Cache address or NULL
 */
void *read_cache(int dev,uint block)
{
	int hash;
	int read_dev=0;		/* Read device flag */
	CACHE_TABLE *p;


	hash=(block/4)%HASH_NUM;

	enter_spinlock(&cache_tbl_gate);
	{
		/* Search in hash table */
	    for(p=cache_hash[hash];;p=p->hnext)
	    {
	    	/* åˤʤ */
	    	if(p==NULL)
	    	{
				/* ָŤå */
        		p=cache_tbl_old;
        		cache_tbl_old=p->next;

        		/* Delete old hash link */
        		p->hprev->hnext=p->hnext;
        		if(p->hnext!=NULL)p->hnext->hprev=p->hprev;

        		/* Add new hash link */
        		p->hnext=cache_hash[hash];
        		p->hprev=(CACHE_TABLE*)&cache_hash[hash];
        		if(cache_hash[hash]!=NULL)cache_hash[hash]->hprev=p;
        		cache_hash[hash]=p;

        		p->dev=dev;
        		p->block=block;

				wait_proc(&p->wait_queue);

				read_dev=1;
				break;
	    	}

	    	/* åˤ */
	    	if((p->block==block)&&(p->dev==dev))
	    	{
	    		/* å󥯤Ƭ˰ư */
	    		p->next->prev=p->prev;
	    		p->prev->next=p->next;
	    		p->prev=cache_tbl_old->prev;
	    		p->next=cache_tbl_old;
	    		cache_tbl_old->prev=p;
	    		p->prev->next=p;

	    		break;
	    	}
	    }
	}
	exit_spinlock(&cache_tbl_gate);

	if(read_dev)
	{

		if(device[dev]->read(p->addr,CACHE_BLOCK_SIZE,block)<0)
		{
			wake_proc(&p->wait_queue);
			return NULL;
		}
	}
	else wait_proc(&p->wait_queue);

	wake_proc(&p->wait_queue);

	return p->addr;
}


/*
 * Write to cache
 * parameters : Device number,Device block,Sorce user buffer,Write bytes(in cache size),Begin offset in cache
 * return : Write bytes or error=-1
 */
int write_cache(int dev,uint block,void *buf,int bytes,size_t begin)
{
	int hash;
	int read_dev=0;		/* Read device flag */
	int error;
	CACHE_TABLE *p;


	if(bytes<=0)return 0;
	if(bytes+begin>CACHE_BLOCK_SIZE)return -EINVAL;

	hash=(block/4)%HASH_NUM;

	enter_spinlock(&cache_tbl_gate);
	{
		/* Search in hash table */
	    for(p=cache_hash[hash];;p=p->hnext)
	    {
	    	/* åˤʤ */
	    	if(p==NULL)
	    	{
				/* ָŤå */
        		p=cache_tbl_old;
        		cache_tbl_old=p->next;

        		/* Delete old hash link */
        		p->hprev->hnext=p->hnext;
        		if(p->hnext!=NULL)p->hnext->hprev=p->hprev;

        		/* Add new hash link */
        		p->hnext=cache_hash[hash];
        		p->hprev=(CACHE_TABLE*)&cache_hash[hash];
        		if(cache_hash[hash]!=NULL)cache_hash[hash]->hprev=p;
        		cache_hash[hash]=p;

        		p->dev=dev;
        		p->block=block;

				read_dev=1;

				break;
	    	}

	    	/* åˤ */
	    	if((p->block==block)&&(p->dev==dev))
	    	{
	    		/* å󥯤Ƭ˰ư */
	    		p->next->prev=p->prev;
	    		p->prev->next=p->next;
	    		p->prev=cache_tbl_old->prev;
	    		p->next=cache_tbl_old;
	    		cache_tbl_old->prev=p;
	    		p->prev->next=p;

	    		break;
	    	}
	    }

	    wait_proc(&p->wait_queue);
	}
	exit_spinlock(&cache_tbl_gate);

	if(read_dev)
		if(device[dev]->read(p->addr,CACHE_BLOCK_SIZE,block)<0)
		{
			wake_proc(&p->wait_queue);
			return -1;
		}
	memcpy_from_user((void*)((uint)p->addr+begin),buf,bytes);

	wake_proc(&p->wait_queue);

	if((error=device[dev]->write(p->addr,CACHE_BLOCK_SIZE/SECTER_SIZE,block))<0)return error;

	return (bytes<=error)?bytes:error;
}
#endif /* IO_CASH */


/***********************************************************************************
 *
 * ƥॳѴؿ
 *
 ***********************************************************************************/


/*
 * forkˤ꡼ƥȤ򥳥ԡ
 * page directorypage tableΥԡҥץåݥ󥿤Υɥ쥹
 * parameters : Destination page directory,Return stack offset
 * return : New Page directory or NULL
 */
uint *fork_page(PROC *org,PROC *proc,void **stack)
{
	uint *dir,*org_page,*page;
	PHYSICAL_PAGE *phys_page;
	PAGE_TABLE_ADDR *pagetable_addr;
	int i,j;


	/* Page directory򥳥ԡ */
	if((dir=(uint*)alloc_kernel_pagemem())==NULL)return NULL;
	memcpy(dir,org->pagedir,PAGE_SIZE);

	/* Kernel stackƤ */
	if((page=(uint*)alloc_kernel_pagemem())==NULL)goto ERROR1;

	dir[BEGIN_KERNEL_STACK/PAGEDIR_ALLOC_SIZE]=(uint)page|PAGE_PRESEN|PAGE_RW;
	org_page=(uint*)(org->pagedir[BEGIN_KERNEL_STACK/PAGEDIR_ALLOC_SIZE]&PAGE_ROUNDDOWN);
	if((*stack=alloc_kernel_pagemem())==NULL)goto ERROR2;
	memcpy(*stack,(void*)(org_page[1023]&PAGE_ROUNDDOWN),PAGE_SIZE);
	page[1023]=(uint)*stack|PAGE_PRESEN|PAGE_RW;
	memset(page,0,1023*sizeof(uint));

	/* Userΰ򥳥ԡ饤Ȥꤹ */
	for(i=BEGIN_USER/PAGEDIR_ALLOC_SIZE;i<END_USER/PAGEDIR_ALLOC_SIZE;++i)
		if(dir[i]!=0)
		{
			org_page=(uint*)(dir[i]&PAGE_ROUNDDOWN);
			enter_spinlock(&org->pagedir_gate);
			{
				clear_rwflag(org_page);
			}
			exit_spinlock(&org->pagedir_gate);

			for(j=0;j<PAGE_NUM;++j)
			{
				if(org_page[j]&PAGE_PRESEN)
				{
					phys_page=get_physpage_from_addr((void*)org_page[j]);
					if((pagetable_addr=(PAGE_TABLE_ADDR*)kmalloc(sizeof(PAGE_TABLE_ADDR)))==NULL)
							goto ERROR2;
					enter_spinlock(&page_alloc_gate);
					{
						/* Increase reference count of PHYSICAL_PAGE */
						++phys_page->ref_count;

						/* Add page table address link struct */
						pagetable_addr->page_table=&org_page[j];
						pagetable_addr->proc=proc;
						pagetable_addr->next=phys_page->page_table_addr;
						phys_page->page_table_addr=pagetable_addr;

						/* Move to new in enable realloc link */
						phys_page->prev->next=phys_page->next;
						phys_page->next->prev=phys_page->prev;
						if(org_page[j]<END_KERNEL)
						{
							phys_page->prev=&kernel_realloc_new;
							phys_page->next=kernel_realloc_new.next;
							kernel_realloc_new.next=phys_page;
						}
						else
						{
							phys_page->prev=&user_realloc_new;
							phys_page->next=user_realloc_new.next;
							user_realloc_new.next=phys_page;
						}
					}
					exit_spinlock(&page_alloc_gate);
				}
				else if(org_page[j]!=0)
					/* Increase reference count of Swap table */
					++page_store_ref_table[org_page[j]>>1];
			}
		}

	return dir;


ERROR2:
	free_pagemem((void*)page[1023]);
	free_pagemem(page);
ERROR1:
	free_pagemem(dir);

	return NULL;
}
