/*
 * mm.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * mm.c ѥإåե
 */


#ifndef mm_h
#define mm_h


#include"types.h"
#include"proc.h"


#ifndef ASM_FILE


enum{
	PAGE_SIZE=0x1000,				/* Page size */
	PAGEDIR_ALLOC_SIZE=0x400000,	/* 1 Page directoryΥɥ쥹ϰ */
	PAGE_BOUND=PAGE_SIZE-1,			/* ڡå */
	PAGE_ROUNDDOWN=~PAGE_BOUND,

	/* Page table flag */
	PAGE_PRESEN=		0x1,	/* Is presence */
	PAGE_RW=			0x2,	/* Is read and write,not read only */
	PAGE_USER=			0x4,	/* Privilege is user,not supervisor */
	PAGE_CASH_DISABLE=	0x10,	/* Disable cash,not able cash */
	PAGE_4M=			0x80	/* Page size is 4M,not 4K */
};


extern uint all_memory_size;


extern inline void flash_tbl(uint *pagedir)
{
	asm volatile(
		"movl	%%eax,%%cr3"
		::"a"(pagedir)
	);
}

extern uint find_all_memsize();
extern void init_physical_page_table();
extern uint *init_idle_page();
extern int init_page_backstore(char*);
extern uint *fork_page(PROC*,PROC*,void**);
extern int load_user_page(void*,int,PROC*);
extern void free_user_page(PROC*);
extern void *kmalloc(size_t);
extern void kfree(void*);
extern int init_cache();
extern void *read_cache(int,uint);
extern int write_cache(int,uint,void*,int,size_t);


#endif


#endif
