/*
 * 8254.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * 8254󥿡Х륿ޡ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <machine/DevInterrupt.h>
#include <lib/lib.h>
#include <kern/timer.h>
#include <dev/8254.h>

#include <kern/debug.h>


//#define DEBUG_8254 1
#ifdef DEBUG_8254
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//================================== PRIVATE ============================================

enum {
	PIT_HZ = 1193181,	/* 8254󥿡Х륿ޡΥإĿ */

	/* 8254 IO register */
	PIT_CNR0=0x40,		/* counter0 register */
	PIT_CTR= 0x43,		/* control register */
};

static volatile int tasking = NO;
static uint intervalTime;		// ߤ֡ms

/*
 * ֡msˤ򥯥åѴ롣
 * return : å
 */
STATIC INLINE uint timeToClock(
	const uint i_time)		// ms
{
	return PIT_HZ * i_time / 1000;
}

/*
 * å֡msˤѴ롣
 * return : ֡ms
 */
STATIC INLINE uint clockToTime(
	const uint i_clock)		// å
{
	return i_clock * 1000 / PIT_HZ;
}

/*
 * ߥϥɥ
 * return : YES = å or NO = åʤ
 */
STATIC int intrIntervalTimer()
{
	uint time = intervalTime;

	intervalTime = 0;

	// ޡϥɥμ¹
	doIntervalTimer(time);

	return tasking;
}

//================================== PUBLIC =============================================

/*
 * ޡϤηв֤롣
 * return : в֡ms
 */
uint getIntervalTimerPastTime()
{
	if (intervalTime == 0) {
		return 0;
	}
	else {
		uint remainClock;
		uint remainTime;

		// Ĥꥯå
		remainClock = inb(PIT_CNR0);
		remainClock += inb(PIT_CNR0) << 8;
		remainTime = clockToTime(remainClock);

		return (remainTime <= intervalTime) ? intervalTime - remainTime : 0;
	}
}

/*
 * ޡ֤ꤹ롣
 */
void setIntervalTimer(
	const uint i_time)		// ֡ms
{
	uint clock = timeToClock(i_time);

	outb(PIT_CNR0, clock & 0xff);
	outb(PIT_CNR0, clock >> 8);
	intervalTime = i_time;
}

/*
 * 󥿡Х륿ޡߤǥåԤꤹ
 */
void setIntervalTasking(
	int isTasking)		// YES NO:ʤ
{
	tasking = isTasking;
}

/*
 * ֤¬
 *այưΤ߻Ѳġ
 */
void setStartClock(void)
{
	outb(PIT_CTR,0x30);	/* CLK0,LSB.MSB,⡼0,binary */
	outb(PIT_CNR0,0);	/* LSB */
	outb(PIT_CNR0,0);	/* MSB */
}

/*
 * 1/20ä¬
 */
void timeIntervalTwentiethSecond()
{
	int low;
	int high;
	int clock;

	do {
		low = inb(PIT_CNR0);
		high = inb(PIT_CNR0);
	} while (low - (high << 8) == 0);

	do {
		low = inb(PIT_CNR0);
		high = inb(PIT_CNR0);
		clock = 0x10000 - low - (high << 8);
	} while (clock < PIT_HZ / 20);
}

/*
 * 
 */
void initIntervalTimer(void)
{
	irq_entry[IRQ0] = intrIntervalTimer;
//	outb(PIT_CTR,0x30);		// One shot timer(mode 0).
//	outb(PIT_CTR,0x34);		// CLK0,LSB.MSB,⡼2,binary.
	release_irq_mask(0);
}
