/*
 * MC146818.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * MC146818ꥢ륯åޡ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <machine/lib.h>
#include <machine/mp.h>
#include <machine/interrupt.h>
#include <isa/isareg.h>
#include <lib/lib.h>
#include <kern/time.h>
#include <kern/timer.h>
#include <dev/MC146818.h>

#include <kern/debug.h>


//#define DEBUG_MC146818 1
#ifdef DEBUG_MC146818
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//================================== PRIVATE ============================================

/*
 * ʿʿѴ롣
 */
STATIC INLINE uchar bcd_to_bin(uchar value)
{
	return value - 6 * (value >> 4);
}

/*
 * get current time from cmos
 * parameters : time structure
 */
STATIC void getCrntTime()
{
	/* ι */
	static ushort sumMonth[][13] = {
		{0,0,31,59,90,120,151,181,212,243,273,304,334},
		{0,0,31,60,91,121,152,182,213,244,274,305,335},
	};
	struct TIME{
		uchar second;		/* seconds */
		uchar minute;		/* minutes */
		uchar hour;			/* hours */
		uchar day;			/* days */
		uchar month;		/* months */
		ushort year;		/* years */
	} time;

	uint unixTime;
	int days;

	do{
		time.second = bcd_to_bin(read_cmos(CMOS_SCD));
		time.minute = bcd_to_bin(read_cmos(CMOS_MNT));
		time.hour = bcd_to_bin(read_cmos(CMOS_HOR));
		time.day = bcd_to_bin(read_cmos(CMOS_DAY));
		time.month = bcd_to_bin(read_cmos(CMOS_MTH));
		time.year = bcd_to_bin(read_cmos(CMOS_YER));
	} while (bcd_to_bin(read_cmos(CMOS_SCD)) < time.second);

	time.year += (time.year < 70)? 2000 : 1900;

	/* UNIX TIMEη׻ */
	days = (time.year - 1970) * 365;
	days += (time.year - 1 - 1968) / 4;
	days += sumMonth[(time.year % 4) == 0][time.month];
	days += time.day - 1;
	unixTime = ((days * 24 + time.hour) * 60 + time.minute) * 60 + time.second;

	unixTime -= LOCAL_TIME_TOKYO;	// 륿Ĵ
	setTime(unixTime);
}

/*
 * ߥϥɥ
 *ճԲĤǸƤӽФ롣
 *        500msȤ˳ȯ
 * return : åʤ
 */
STATIC int intrRealTimer()
{
	// ֤򹹿
	updateTime();

	// ޡϥɥμ¹
	doRealTimer(REAL_TIMER_RATE);

	// Status register C ɤǳߤꥻåȤ롣
	read_cmos(CMOS_STRC);

	return 0;
}

//================================== PUBLIC =============================================

/*
 * ޡϤηв֤롣
 * return : в֡ms
 */
uint getRealTimerPastTime()
{
	// ˣ
	return 0;
}

/*
 * ޡ֤ꤹ롣
 */
void setRealTimer(
	const uint i_time)		// ֡ms
{
	// ⤷ʤ
}

/*
 * CMOS read.
 */
uchar read_cmos(int addr)
{
	outb(CMOS_ADR, addr | NMI_ENABLE);
	return inb(CMOS_DTR);
}

/*
 * CMOS write.
 */
void write_cmos(int addr, uchar value)
{
	outb(CMOS_ADR, addr | NMI_ENABLE);
	outb(CMOS_DTR, value);
}

/*
 * read real time clock.
 */
int rtcin(int reg)
{
	u_char val;

	outb(IO_RTC, reg);
	inb(0x84);
	val = inb(IO_RTC + 1);
	inb(0x84);

	return (val);
}

/*
 * 
 */
void initRealTimer()
{
	getCrntTime();

	// ߤ
	irq_entry[IRQ8] = intrRealTimer;
	write_cmos(CMOS_STRA, 0x2f);		/* time bese 0x010(default)|ޡ졼65536/(20xf)=2HZ(500ms) */
	read_cmos(CMOS_STRC);				/* Status register C ɤǳߤꥻåȤ롣 */
	write_cmos(CMOS_STRB, 0x42);		/* 24hour,ߥ */
	release_irq_mask(8);
}
