/*
 * MC146818.h
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef DEV_MC146818_h
#define DEV_MC146818_h


#ifndef ASM_FILE


enum {
	/* Real-clock timer rate(ms) */
	REAL_TIMER_RATE	= 500,

	/* MC146818 CMOS RAM and real-time clock IO register */
	CMOS_ADR	= 0x70,	/* address register */
	CMOS_DTR	= 0x71,	/* data register */
	CMOS_SCD	= 0x0,	/* second */
	CMOS_MNT	= 0x2,	/* minute */
	CMOS_HOR	= 0x4,	/* hour */
	CMOS_DAY	= 0x7,	/* day */
	CMOS_MTH	= 0x8,	/* month */
	CMOS_YER	= 0x9,	/* year */
	CMOS_STRA	= 0xa,	/* status register A */
	CMOS_STRB	= 0xb,	/* status register B */
	CMOS_STRC	= 0xc,	/* status register C */

	NMI_ENABLE	= 0x80,	/* NMI interrupt enable,CMOS address register˽񤭹Ȥꤹ롣 */
};


extern uint getRealTimerPastTime();
extern void setRealTimer(const uint);
extern uchar read_cmos(int);
extern void write_cmos(int, uchar);
extern void initRealTimer();


#endif


#endif
