/*
 * miscdev.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ¾ΥǥХɥ饤С
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/conf.h>
#include <kern/devfs.h>
#include <kern/device.h>


/************************************************************************************************
 *
 * Null device class
 *
 * ⤷ʤ
 *
 ************************************************************************************************/

static int open(dev_t dev, int oflags, int devtype, d_thread_t *proc)
{
	return 0;
}


static int close(dev_t dev, int fflag, int devtype, d_thread_t *proc)
{
	return 0;
}


static int read(dev_t dev, struct uio *uio, int ioflag)
{
	return 0;
}


static int write(dev_t dev, struct uio *uio, int ioflag)
{
	return 0;
}


static int ioctl(dev_t dev, u_long cmd, caddr_t data, int fflag, d_thread_t *p)
{
	return 0;
}


static int poll(dev_t dev, int events, d_thread_t *p)
{
	return POLLIN | POLLRDNORM | POLLOUT | POLLWRNORM;
}


static struct cdevsw cdevsw = {
	open, 
	close, 
	read, 
	write, 
	ioctl, 
	poll, 
	NULL, 
	NULL, 
	"null",
	0,
	NULL, 
	NULL, 
	D_MEM,
};


int registNullDev()
{
	dev_t dev;
	
	dev = make_dev(&cdevsw, 0, 0, 0, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP, "null");
	if (dev == NODEV) {
		return -ENODEV;
	}

	// ǥХե
	makeDevf(cdevsw.d_name, dev, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);

	return 0;
}
