/*
 * Except.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * 㳰ϥɥ
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/syscall.h>
#include <lib/lib.h>
#include <kern/Thread.h>
#include <kern/TaskSignal.h>
#include <kern/lock.h>
#include <i386/segment.h>
#include <i386/lib.h>
#include <i386/fpu.h>
#include <i386/interrupt.h>
#include <i386/Cpu.h>
#include <i386/debug.h>
#include <i386/vm.h>
#include <i386/Entry.h>
#include <i386/Except.h>

#include <kern/debug.h>


//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

//--------------------------------------------------------------------------------------------------
// 㳰ϥɥ
//--------------------------------------------------------------------------------------------------

/*
 * 㳰ϥɥ
 */
static void exception(const char *message, int signal, TaskContext *frame)
{
	printk("\nException! %s.",message);
	printContext(frame);
	forceSendSignal(TaskGetTaskSignal(getCurrentTask()), signal);
}

/*
 * 顼
 */
static void excDivideError(
	TaskContext frame)
{
	exception("Divide error", SIGFPE, &frame);
}

/*
 * NMI
 */
static void excNonmaskableInterrupt(
	TaskContext frame)
{
	char value;

	printk("\nException! Nonmaskable interrupt.\n");

	value=inb(0x61);		/* System control portB. */
	if(value&0x80)
		printk("Memory parity error.\n");
	if(value&0x40)
		printk("IO channel parity error.\n");
	if((value&0xc0)==0)
		printk("Unknown NMI error.\n");

	/* Reset NMI interrupt. */
	outb(0x70,0x8f);
	inb(0x71);
	outb(0x70,0x0f);
	inb(0x71);
}

/*
 * Сե
 */
static void excOverflow(
	TaskContext frame)
{
	exception("Overflow", SIGSEGV, &frame);
}

/*
 * BOUNDϰϳ
 */
static void excBoundsCheck(
	TaskContext frame)
{
	exception("Bounds check", SIGSEGV, &frame);
}

/*
 * ̵ڥ
 */
static void excInvalidOpcode(
	TaskContext frame)
{
	exception("Invalid opcode", SIGILL, &frame);
}

/*
 * ֥ե
 */
static void excDoubleFault(
	TaskContext frame)
{
	exception("Double fault", SIGSEGV, &frame);
}

/*
 * ץåС
 */
static void excCopressorOverrun(
	TaskContext frame)
{
	exception("Copressor segment overrun", SIGFPE, &frame);
}

/*
 * ̵TSS
 */
static void excInvalidTss(
	TaskContext frame)
{
	exception("Invalid TSS", SIGSEGV, &frame);
}

/*
 * Ժ
 */
static void excSegmentNotPresent(
	TaskContext frame)
{
	exception("Segment not present", SIGBUS, &frame);
}

/*
 * åȥե
 */
static void excStackException(
	TaskContext frame)
{
	exception("Stack exception", SIGBUS, &frame);
}

/*
 * ݸ
 */
static void excGeneralProtection(
	TaskContext frame)
{
	exception("General protection", SIGSEGV, &frame);
}

/*
 * FPUư顼
 */
static void excFpuError(
	TaskContext frame)
{
	exception("FPU error", SIGFPE, &frame);
}

/*
 * 饤ȥå
 */
static void excAlignmentCheck(
	TaskContext frame)
{
	exception("Alignment check", SIGBUS, &frame);
}

/*
 * ޥå
 */
static void excMachineCheck(
	TaskContext frame)
{
	/* ̤ */
	exception("Machine check", 0, &frame);
}

/*
 * SIMDư㳰
 */
static void excSimdFpuError(
	TaskContext frame)
{
	exception("SIMD FPU error", SIGFPE, &frame);
}

/*
 * ͽ㳰
 */
static void excReserve(
	TaskContext frame)
{
	exception("Not Defined exception!", 0,  &frame);
}

//===================================== PUBLIC =====================================================

/*
 * 㳰
 *յư˸ƤӽФ
 */
void init_except()
{
	// ߥȥ꡼Ͽ
	setExceptEntry(0,  excDivideError);
	setExceptIntrEntry(1, debugHandler);
	setExceptEntry(2,  excNonmaskableInterrupt);
	setExceptIntrEntry(3, excBreakpoint);
	setExceptEntry(4,  excOverflow);
	setExceptEntry(5,  excBoundsCheck);
	setExceptEntry(6,  excInvalidOpcode);
	setExceptIntrEntry(7, doCoprocessorNotAvailable);
	setExceptEntry(8,  excDoubleFault);
	setExceptEntry(9,  excCopressorOverrun);
	setExceptEntry(10, excInvalidTss);
	setExceptEntry(11, excSegmentNotPresent);
	setExceptEntry(12, excStackException);
	setExceptEntry(13, excGeneralProtection);
	setExceptIntrEntry(14, receivePageFault);
	setExceptEntry(15, excReserve);
	setExceptEntry(16, excFpuError);
	setExceptEntry(17, excAlignmentCheck);
	setExceptEntry(18, excMachineCheck);
	setExceptEntry(19, excSimdFpuError);
}

/*
 * 㳰ȯƥȤϤ
 */
void printContext(
	TaskContext *i_frame)
{
	uint *stack;

	if ((i_frame->cs == KERNEL_CODE_DES) || (i_frame->cs == APM_CODE_DES)) {
		printk("error=%x eip=%x cs=%x ds=%x esp=%x proc=%x pagedir=%x\n",
			i_frame->error,
			i_frame->eip,
			i_frame->cs,
			i_frame->ds,
			&i_frame->user_esp,
			getCurrentProc(),
			getPageDir(getVmTask(getCurrentTask())));
		stack = &i_frame->user_esp;
	}
	else {
		printk("error=%x eip=%x cs=%x esp=%x ss=%x proc=%x pagedir=%x\n",
			i_frame->error,
			i_frame->eip,
			i_frame->cs,
			i_frame->user_esp,
			i_frame->ss,
			getCurrentProc(),
			getPageDir(getVmTask(getCurrentTask())) );
		stack = (uint*) i_frame->user_esp;
	}
	printk("stack:0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x\n",
		stack[0],
		stack[1],
		stack[2],
		stack[3],
		stack[4],
		stack[5],
		stack[6],
		stack[7],
		stack[8],
		stack[9]); 

#ifdef DEBUG
	printSyscallEntry(3);
#endif
//****************************************************************************
idle();
//****************************************************************************
}
