/*-
 * Copyright (c) 1997 Michael Smith
 * Copyright (c) 1998 Jonathan Lemon
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/i386/include/pc/bios.h,v 1.7.2.3 2001/10/21 03:16:56 yokota Exp $
 */


#ifndef _MACHINE_BIOS_H_
#define	_MACHINE_BIOS_H_


#include <sys/types.h>


#ifndef ASM_FILE


/*
 * PCI BIOS functions
 */
#define PCIBIOS_BIOS_PRESENT		0xb101
#define PCIBIOS_READ_CONFIG_BYTE	0xb108
#define PCIBIOS_READ_CONFIG_WORD	0xb109
#define PCIBIOS_READ_CONFIG_DWORD	0xb10a
#define PCIBIOS_WRITE_CONFIG_BYTE	0xb10b
#define PCIBIOS_WRITE_CONFIG_WORD	0xb10c
#define PCIBIOS_WRITE_CONFIG_DWORD	0xb10d
#define PCIBIOS_GET_IRQ_ROUTING		0xb10e
#define PCIBIOS_ROUTE_INTERRUPT		0xb10f


struct bios_regs {
	u_int	eax;
	u_int	ebx;
	u_int	ecx;
	u_int	edx;
	u_int	esi;
	u_int	edi;
};

/* 
 * Signature structure for the BIOS32 Service Directory header 
 */
struct bios32_SDheader {
    u_int8_t	sig[4];
    u_int32_t	entry;
    u_int8_t	revision;
    u_int8_t	len;
    u_int8_t	cksum;
    u_int8_t	pad[5];
};

/*
 * PCI interrupt routing table.
 *
 * $PIR in the BIOS segment contains a PIR_table
 * int 1a:b106 returns PIR_table in buffer at es:(e)di 
 * int 1a:b18e returns PIR_table in buffer at es:(e)di 
 * int 1a:b406 returns es:di pointing to the BIOS PIR_table
 */
struct PIR_header {
    int8_t		ph_signature[4];
    u_int16_t	ph_version;
    u_int16_t	ph_length;
    u_int8_t	ph_router_bus;
    u_int8_t	ph_router_dev_fn;
    u_int16_t	ph_pci_irqs;
    u_int16_t	ph_router_vendor;
    u_int16_t	ph_router_device;
    u_int32_t	ph_miniport;
    u_int8_t	ph_res[11];
    u_int8_t	ph_checksum;
} __attribute__ ((packed));

struct PIR_intpin {
    u_int8_t	link;
    u_int16_t	irqs;
} __attribute__ ((packed));

struct PIR_entry {
    u_int8_t			pe_bus;
    u_int8_t			pe_res1:3;
    u_int8_t			pe_device:5;
    struct PIR_intpin	pe_intpin[4];
    u_int8_t			pe_slot;
    u_int8_t			pe_res3;
} __attribute__ ((packed));

struct PIR_table {
    struct PIR_header	pt_header;
    struct PIR_entry	pt_entry[0];
} __attribute__ ((packed));

/* 
 * BIOS32 Service Directory entry.  Caller supplies name, bios32_SDlookup
 * fills in the rest of the details.
 */
struct bios32_SDentry {
    union {
		u_int8_t	name[4];	/* service identifier */
		u_int32_t	id;			/* as a 32-bit value */
    } ident;
    u_int32_t	base;			/* base of service */
    u_int32_t	len;			/* service length */
    u_int32_t	entry;			/* entrypoint offset from base */
    vm_offset_t	ventry;			/* entrypoint in kernel virtual segment */
};

extern struct bios32_SDentry	PCIbios;

extern u_int32_t bios_sigsearch(u_int32_t start, u_char *sig, int siglen, int paralen, int sigofs);
extern int bios32(struct bios_regs *, u_int);
extern void bios32_init();


#endif


#endif
