/*
 * lib_asm.S
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ֥롼饤֥꡼
 */


#define ASM_FILE


#include <machine/segment.h>


.text


/*
 * void idle();
 * ɥ롼
 */
.globl idle
idle:
	hlt
	jmp		idle


/*
 * ֤ : å
 * long long rdtsc()
 */
.globl rdtsc
rdtsc:
	rdtsc
	ret

// uint getFualtAddr()
.globl getFualtAddr
getFualtAddr:
	movl	%cr2, %eax	// եɥ쥹
	ret


/*
 * Сåפʤԡ
 * P6ץåξ硢ɥ쥹8Хȶ256ХȰʾΥԡʤ®ǥԡ
 * void *memcpy(void *dest,const void *src, size_t n);
 */
.globl memcpy
memcpy:
	pushl	%esi
	pushl	%edi
	movl	12(%esp), %edi
	movl	16(%esp), %esi
	cmpl	%esi, %edi
	je		1f

	/* Adjust alignment by 4bytes */
	xorl	%ecx, %ecx
	subl	%esi, %ecx
	andl	$0x3, %ecx
	cmpl	20(%esp), %ecx
	ja		2f
	movl	%ecx, %eax
	rep
	movsb

	/* Move by 4bytes */
	movl	20(%esp), %ecx
	subl	%eax, %ecx
	movl	%ecx, 20(%esp)
	shrl	$2, %ecx
	rep
	movsl

	/* Move rest by bytes */
2:	movl	20(%esp), %ecx
	andl	$0x3, %ecx
	rep
	movsb

1:	movl	12(%esp), %eax
	popl	%edi
	popl	%esi
	ret


/*
 * Сåפ륳ԡ
 * void memCpyBack(void *dest,const void *src, size_t n);
 */
.globl memCpyBack
memCpyBack:
	pushl	%esi
	pushl	%edi
	movl	12(%esp), %edi
	movl	16(%esp), %esi
	movl	20(%esp), %ecx
	std

	addl	%ecx, %edi
	addl	%ecx, %esi
	decl	%edi
	decl	%esi
	rep
	movsb

	cld
	popl	%edi
	popl	%esi
	ret


/*
 * P6ץåξ硢ɥ쥹8Хȶ256ХȰʾΥԡʤ®ǥԡ
 * void *memset(void *dest,int c,size_t n);
 */
.globl memset
memset:
	pushl	%edi
	movl	8(%esp), %edi
	movl	12(%esp), %eax
	movl	16(%esp), %ecx
	orl		%ecx, %ecx
	je		1f

	/* Adjust alignment by 8bytes */
	xorl	%ecx, %ecx
	subl	%edi, %ecx
	andl	$0x7, %ecx
	cmpl	16(%esp), %ecx
	ja		2f
	movl	%ecx, %edx
	rep
	stosb

	/* Store by 4bytes */
	movb	%al, %ah
	movl	%eax, %ecx
	shll	$16, %eax
	orl		%ecx, %eax
	movl	16(%esp), %ecx
	subl	%edx, %ecx
	movl	%ecx, 16(%esp)
	shrl	$2, %ecx
	rep
	stosl

	/* Store rest by bytes */
2:	movl	16(%esp), %ecx
	andl	$0x3, %ecx
	rep
	stosb

1:	movl	12(%esp), %eax
	popl	%edi
	ret

/*
 * ꥢ⡼ɤ˰ܹԤƻΥɥ쥹إפ롣
 *եץɥ쥹0x10000̤Ǥ뤳
 * void switchRealMode(void *jumpAddr);
 */
.globl switchRealMode
switchRealMode:
	movl	4(%esp), %eax
	movw	%ax, jumpOffset

	call	storeRealIdt
	cli
	lidt	realIdtr

/* Flash TLB. */
	movl	%cr0, %eax
	andl	$0x7fffffff, %eax
	movl	%eax, %cr0
	xorl	%eax, %eax
	movl	%eax, %cr3


/* ꥢ⡼ѥȤΥɡ */
	movl	$REAL_DATA_DES, %eax
	movl	%eax, %ss
	movl	%eax, %ds
	movl	%eax, %es
	movl	%eax, %fs
	movl	%eax, %gs
	ljmp	$REAL_CODE_DES, $realMode

.code16
realMode:
	movl	%cr0, %eax
	andl	$0xfffffffe, %eax
	movl	%eax, %cr0
	wbinvd
	movw	$REAL_SS_SEG, %ax
	movw	%ax, %ss
	movw	$REAL_SP_REG, %sp
	sti

	jmp		*jumpOffset

.globl jumpToBios
jumpToBios:
	ljmp	$0xffff, $0


jumpOffset:
	.word	jumpToBios


.data


/* ꥢ⡼IDTR. */
realIdtr:
	.word	0x3ff
	.long	0
