/*
 * sp.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * 󥰥ץåƥν
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <dev/console/console.h>
#include <dev/8254.h>
#include <lib/lib.h>
#include <kern/time.h>
#include <kern/timer.h>
#include <i386/syscall.h>
#include <i386/interrupt.h>
#include <i386/Entry.h>
#include <i386/sp.h>


//#define DEBUG_SP 1
#ifdef DEBUG_SP
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE inline
#endif

//===================================== Х륤ݡ =======================================

extern int doKernIntrHandler(const int);

//================================== PRIVATE ============================================

enum{
	BEGIN_VECT = 0x20		// ߥ٥γֹ
};

// ϡɳEOIؿ
STATIC void spEoi(
	uchar irq)
{
	if (irq < 8){
		outb(OCW2M, 0x20);
	}
	else{
		outb(OCW2S, 0x20);
		outb(OCW2M, 0x20);
	}
}

// Set interrupt mask
STATIC void set_pic_mask(
	const uchar irq)	// IRQ number
{
	if (irq < 8) {
		outb(OCW1M, inb(OCW1M) | (1 << irq));
	}
	else {
		outb(OCW1S, inb(OCW1S) | (1 << (irq - 8)));
	}
}

// Release interrupt mask
STATIC void release_pic_mask(
	const uchar irq)	// IRQ number
{
	if (irq < 8) {
		outb(OCW1M, inb(OCW1M) & ~(1 << irq));
	}
	else {
		outb(OCW1S, inb(OCW1S) & ~(1 << (irq - 8)));
	}
}

/*
 * PIC
 */
STATIC void init_pic()
{
	/* picν */
	outb(ICW1M, 0x11);				/* cascade mode */
	outb(ICW1S, 0x11);				/* ICW1 slave */
	outb(ICW2M, BEGIN_VECT);		/* begin master interrupt from 0x20 */
	outb(ICW2S, BEGIN_VECT + 8);	/* begin slave interrupt from 0x28 */
	outb(ICW3M, 0x04);				/* IR2(2bit) slave connect */
	outb(ICW3S, 0x02);				/* slave connect IR-number */
	outb(ICW4M, 0x01);				/* 80x86 mode,Normal EOI */
	outb(ICW4S, 0x01);				/* 80x86 mode,Normal EOI */
	outb(OCW1M, 0xfb);				/* Mask of all IRQ except IRQ2 */
	outb(OCW1S, 0xff);				/* Mask of all IRQ */

	// ߥȥ꡼Ͽ
	setDevIntrEntry(BEGIN_VECT,    IRQ0,  doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+1,  IRQ1,  doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+3,  IRQ3,  doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+4,  IRQ4,  doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+5,  IRQ5,  doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+6,  IRQ6,  doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+7,  IRQ7,  doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+8,  IRQ8,  doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+9,  IRQ9,  doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+10, IRQ10, doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+11, IRQ11, doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+12, IRQ12, doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+13, IRQ13, doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+14, IRQ14, doKernIntrHandler, spEoi);
	setDevIntrEntry(BEGIN_VECT+15, IRQ15, doKernIntrHandler, spEoi);
}

/*
 *Գ
 * 󥰥ϥɥ
 */
STATIC void handleTasking(
	void *dummy)		// ̤
{
	// åԤ
	setIntervalTasking(YES);
/********************************************************************/
	{
		static char value = '0';

		if ('9' < value){
			value = '0';
		}
		displayTop(50, &value, 1);
		++value;
	}
/********************************************************************/
}

//================================== PUBLIC =============================================

/*
 * SPƥν
 * return : error number
 */
int init_sp()
{
	void *timer;

	// PICν
	init_pic();

	// ϡɳߤEOIؿꤹ
	irq_eoi = spEoi;

	// ϡɳߥޥؿޥؿꤹ
	release_irq_mask = release_pic_mask;
	set_irq_mask = set_pic_mask;

	// åޡκ
	return setSystemTimer(TASK_TIME, TASK_TIME, handleTasking, NULL, &timer);
}
