/*
 * syscall.h
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef i386_syscall_h
#define i386_syscall_h


#include <i386/Entry.h>


#ifndef ASM_FILE


typedef struct {
	uint param1;
	uint param2;
	uint param3;
	uint param4;
	uint param5;
	uint param6;
	TaskContext context;
} SYSCALL0_INTR_FRAME;

typedef struct {
	uint param2;
	uint param3;
	uint param4;
	uint param5;
	uint param6;
	TaskContext context;
} SYSCALL1_INTR_FRAME;

typedef struct {
	uint param3;
	uint param4;
	uint param5;
	uint param6;
	TaskContext context;
} SYSCALL2_INTR_FRAME;

// ƥॳ륹åե졼
typedef struct {
	uint param1;
	uint param2;
	uint param3;
	uint param4;
	uint param5;
	uint param6;
	uint ebp;
	uint edi;
	uint esi;
	uint eip;
	uint cs;
	uint para[7];
	uint user_esp;
	uint ss;
} SYSCALL1_FRAME;

typedef struct {
	uint param2;
	uint param3;
	uint param4;
	uint param5;
	uint param6;
	uint ebp;
	uint edi;
	uint esi;
	uint eip;
	uint cs;
	uint para[7];
	uint user_esp;
	uint ss;
}SYSCALL2_FRAME;

typedef struct {
	uint param3;
	uint param4;
	uint param5;
	uint param6;
	uint ebp;
	uint edi;
	uint esi;
	uint eip;
	uint cs;
	uint para[7];
	uint user_esp;
	uint ss;
}SYSCALL3_FRAME;

typedef struct {
	uint param4;
	uint param5;
	uint param6;
	uint ebp;
	uint edi;
	uint esi;
	uint eip;
	uint cs;
	uint para[7];
	uint user_esp;
	uint ss;
}SYSCALL4_FRAME;

typedef struct {
	uint param5;
	uint param6;
	uint ebp;
	uint edi;
	uint esi;
	uint eip;
	uint cs;
	uint para[7];
	uint user_esp;
	uint ss;
}SYSCALL5_FRAME;

typedef struct {
	uint param6;
	uint ebp;
	uint edi;
	uint esi;
	uint eip;
	uint cs;
	uint para[7];
	uint user_esp;
	uint ss;
}SYSCALL6_FRAME;

typedef struct {
	uint ebp;
	uint edi;
	uint esi;
	uint eip;
	uint cs;
	uint para[7];
	uint user_esp;
	uint ss;
}SYSCALL7_FRAME;

// ⥸塼륷ƥॳ
typedef struct {
	uint param6;
	uint eip;
	uint cs;
	uint para[7];
	uint user_esp;
	uint ss;
} SYSCALL5_MODULE_FRAME;


extern int syscall();

extern int startExec(const char*, void*, void*);
extern uint getFrame0UserEsp(const SYSCALL0_INTR_FRAME *);
extern uint getFrame1UserEsp(const SYSCALL1_INTR_FRAME *);
extern uint getFrame2UserEsp(const SYSCALL2_INTR_FRAME *);


#endif


#endif
