/*
 * ProcSignal.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef kren_ProcSignal_h
#define kren_ProcSignal_h


#include <sys/signal.h>


#ifndef ASM_FILE


typedef int (*SIG_HANDLER)(int);

/*
 *԰¸ProcSignalƱ
 */
typedef struct {
	char dummy[sizeof(int) * 97];
} ProcSignalObj;

extern int ProcSignalInit();
extern void ProcSignalConstructor(ProcSignalObj*);
extern void ProcSignalCopyConstructor(ProcSignalObj*, ProcSignalObj*);
extern void ProcSignalDestructor(ProcSignalObj*);
extern void ProcSignalSetMask(const int);
extern void resetProcSignal(ProcSignalObj*);
extern void setSigAllMask();
extern SIG_HANDLER ProcSignalGetHandler(ProcSignalObj*, const int);
extern sigset_t *ProcSignalGetHandlerMask(ProcSignalObj*, const int);
extern void *ProcSignalGetReturnMethod(ProcSignalObj*);

extern int sys_sigaction();
extern int sys_sigprocmask();
extern int sys_kill();
extern int sys_sigpending();
extern int sys_sigsuspend();


#endif

#endif
