/*
 * Thread.h
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef Thread_h
#define Thread_h


#include <sys/types.h>
#include <sys/List.h>
#include <kern/timer.h>
#include <kern/vm.h>
#include <kern/Wait.h>
#include <kern/TaskSignal.h>


#ifndef ASM_FILE


/*
 * 桼åɥ֥
 *աեϰפƤʤΤǡݥ󥿤ȤƤΤ߻Ѥ뤳
 */
typedef struct {
	char dummy[sizeof(int) * 1];
} ThreadObj;

enum{
	// 
	TASK_RUNNING		= 1 << 0,
	TASK_WAIT			= 1 << 1,
	TASK_DEVICE_WAIT	= 1 << 2,		// ǥХԤ
	TASK_SIGNAL_WAIT	= 1 << 3,		// ʥԤ
	TASK_SIGNAL_STOP	= 1 << 4,		// ʥˤ
	TASK_TRACE			= 1 << 5,		// ȥ졼
	TASK_EXIT			= 1 << 6,		// Exit
	TASK_CHILD_WAIT		= 1 << 7,		// wait callԤ
	
	TASK_PARAM_BUF		= 12,			// åѥ᡼Хåե
};

// 塼
extern void initSchedule(int);
extern void setFirstTask(const int, ThreadObj*);
extern int addToSchedule(ThreadObj*, const int);
extern int addScheduleSoon(ThreadObj*, const int);
extern void delFromSchedule(const int);
extern void changeTask(ThreadObj*);
extern void *switchTask();
extern void addNewTask(ThreadObj*);
extern ThreadObj *getCurrentTask();

// 
extern int getTaskState(ThreadObj*);
extern VmTaskObj *getVmTask(ThreadObj*);
extern List *getWaitList(ThreadObj*);
extern WaitObj *getWaitTask(ThreadObj*);
extern int getIrqTask(ThreadObj*);
extern ThreadObj *getCallTask(ThreadObj*);
extern ThreadObj *getCallDstTask(ThreadObj*);
extern void *getParamBuf(ThreadObj*);
extern void setIrqTask(ThreadObj*, const int);
extern void setCallTask(ThreadObj*);
extern void *changeCallTask();
extern void *restoreCallTask();
extern TIMER_OWNER *getTaskTimer(ThreadObj*);
extern TaskSignalObj *TaskGetTaskSignal(ThreadObj*);
extern void incrementNest();
extern void decrementNest();
extern int isNest();
extern void calcTaskUserTime();
extern void calcTaskSysTime();
extern void setTaskCurrentTime();
extern void taskExit();

// å
extern pthread_t threadGetId(ThreadObj*);
extern pthread_t threadGetJoinId(ThreadObj*);
extern List *getProcList(ThreadObj*);
extern void *ThreadGetProc(ThreadObj*);
extern uint64 getUserClocks(ThreadObj*);
extern uint64 getSysClocks(ThreadObj*);
extern int createIdleThread(const int, void*, ThreadObj**);
extern int forkThread(const int, void*, void*, void*, ThreadObj**);
extern void freeThread(ThreadObj*, VmProcObj*);

// ƥॳ
extern int sys_pthread_create();
extern int sys_pthread_join();
extern void sys_pthread_exit();

#ifdef DEBUG
void displaySchedule(const int);
#endif


#endif


#endif
