/*
 * Wait.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/buf.h>
#include <machine/interrupt.h>
#include <kern/ProcSignal.h>
#include <kern/lock.h>
#include <kern/timer.h>
#include <kern/Thread.h>
#include <kern/Wait.h>

#include <kern/debug.h>


//#define DEBUG_WAIT 1
#ifdef DEBUG_WAIT
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

/*
 * ȹ¤
 *ԱƶեСѹVmTaskObjΥѹ뤳
 */
typedef struct {
	ThreadObj	*task;
	int			wake;		// ե饰
	int			spinLock;	// ԥå
} Wait;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

/*
 * Ԥ
 */
STATIC void wait(
	const int i_state)
{
	Wait *this = (Wait*) getWaitTask(getCurrentTask());
	int eflag;

	eflag = enterCli();
	{
		enter_spinlock(&this->spinLock);

		if (this->wake == i_state) {
			this->wake = 0;
			exit_spinlock(&this->spinLock);
		}
		else {
			delFromSchedule(i_state);
			this->wake = 0;
			exit_spinlock(&this->spinLock);
			wait_task();
		}
	}
	exitCli(eflag);
}

/*
 * 򵯤
 *Գ
 */
STATIC void wake(
	Wait *this,
	const int i_state,
	int (*addScheduleMethod)(ThreadObj*, const int))
{
	int eflag;

	eflag = enterCli();
	enter_spinlock(&this->spinLock);
	{
		if (addScheduleMethod(this->task, i_state) == NO) {
			this->wake = i_state;
		}
	}
	exit_spinlock(&this->spinLock);
	exitCli(eflag);
}

/*
 * ޡϤϥɥ
 *Գ
 */
STATIC void handleWake(
	void *i_task)
{
	addToSchedule(i_task, TASK_SIGNAL_WAIT);
}

//===================================== PUBLIC =====================================================

/*
 * 󥹥ȥ饯
 */
void waitConstruct(
	WaitObj *i_this,
	ThreadObj *i_task)
{
	Wait *this = (Wait*) i_this;

	this->task = i_task;
	this->wake = 0;
	this->spinLock = 0;
}

/*
 * Ԥ
 */
void waitTask()
{
	wait(TASK_WAIT);
}

/*
 * 򵯤
 *оݥwaitTask()ԤˤʤäƤ
 *Գ
 */
void activeTask(
	WaitObj *i_this)
{
	Wait *this = (Wait*) i_this;
	wake(this, TASK_WAIT, addToSchedule);
}

/*
 * Ԥʥǵ
 */
void waitTaskSignal()
{
	wait(TASK_SIGNAL_WAIT);
}

/*
 * Ԥʥǵ
 */
uint waitTimeSignal(
	const uint i_miliSeconds)
{
	void *timer;
	uint remainTime;
	int error;

	if (i_miliSeconds == 0){
		return 0;
	}

	error = setTaskTimer(i_miliSeconds, 0, handleWake, getCurrentTask(), &timer);
	if (error != NOERR){
		return i_miliSeconds;
	}

	wait(TASK_SIGNAL_WAIT);

	// Ĥ֤
	remainTime = getRemainTime(timer);

	// 
	freeTimer(timer);

	return remainTime;
}

/*
 * ʥ뵯ĥ򵯤
 *оݥwaitTaskSignal()ԤˤʤäƤ뤳
 *Գ
 */
void activeTaskSignal(
	WaitObj *i_this)
{
	Wait *this = (Wait*) i_this;
	wake(this, TASK_SIGNAL_WAIT, addToSchedule);
}

/*
 * ʥ뵯ĥ˵
 *оݥwaitTaskSignal()ԤˤʤäƤ뤳
 *Գ
 */
void activeTaskSoonSignal(
	WaitObj *i_this)
{
	Wait *this = (Wait*) i_this;
	wake(this, TASK_SIGNAL_WAIT, addScheduleSoon);
}

/*
 * 򥹥꡼פ
 */
void sleepTask(
	const int i_state)		// ץξ֥ե饰
{
	int eflag;

	eflag = enterCli();
	{
		delFromSchedule(i_state);
		wait_task();
	}
	exitCli(eflag);
}

/*
 * 򵯾
 *оݥwaitTask()sleepTask()ԤˤʤäƤ뤳
 */
void wakeTask(
	WaitObj *i_this,
	const int i_state)
{
	Wait *this = (Wait*) i_this;
	addToSchedule(this->task, i_state);
}

/*
 * 򵯾
 *оݥwaitTask()sleepTask()ԤˤʤäƤ뤳
 */
void wakeTaskSoon(
	WaitObj *i_this,
	const int i_state)
{
	Wait *this = (Wait*) i_this;
	addScheduleSoon(this->task, i_state);
}

/*
 * λ
 */
int exitSchedule()
{
	cli();
	delFromSchedule(TASK_EXIT);

	return YES;
}

/*
 * ߤ
 *奿åޤǳ߶ػߤ뤳
 * return : task switch YES or NO
 */
int stopSchedule()
{
	cli();
	delFromSchedule(TASK_SIGNAL_STOP);

	return YES;
}

//--------------------------------------------------------------------------------------------------
// ƥॳ
//--------------------------------------------------------------------------------------------------

/*
 *FreeBSD
 * General sleep call.  Suspends the current process until a wakeup is
 * performed on the specified identifier.  The process will then be made
 * runnable with the specified priority.  Sleeps at most timo/hz seconds
 * (0 means no timeout).  If pri includes PCATCH flag, signals are checked
 * before and after sleeping, else signals are not checked.  Returns 0 if
 * awakened, EWOULDBLOCK if the timeout expires.  If PCATCH is set and a
 * signal needs to be delivered, ERESTART is returned if the current system
 * call should be restarted if possible, and EINTR is returned if the system
 * call should be interrupted by the signal (return EINTR).
 */
int tsleep(
	void *chan, 
	int pri, 
	const char *wmesg, 
	int timeout)
{
	struct buf *bp = chan;
	void *timer;
	uint remainTime;
	int error;

	bp->task = getCurrentTask();

	if (0 < timeout) {
		error = setTaskTimer(timeout, 0, handleWake, getCurrentTask(), &timer);
		if (error != NOERR) {
			return 0;
		}

		waitTaskSignal();
		if ((pri & PCATCH) != 0) {
			if (isSigint(TaskGetTaskSignal(getCurrentTask())) == YES) {
				return EINTR;
			}
		}

		// Ĥ֤
		remainTime = getRemainTime(timer);

		// 
		freeTimer(timer);
		
		if (remainTime == 0) {
			return EWOULDBLOCK;
		}
	}
	else if (timeout == 0) {
		waitTaskSignal();
		if ((pri & PCATCH) != 0) {
			if (isSigint(TaskGetTaskSignal(getCurrentTask())) == YES) {
				return EINTR;
			}
		}
	}

	return 0;
}

/*
 *FreeBSD
 */
void wakeup(
	void *chan)
{
	struct buf *bp = chan;

	activeTaskSoonSignal(getWaitTask(bp->task));
}

int sys_sleep(
	uint seconds)
{
	void *timer;
	uint remainTime;
	int error;

	if (seconds == 0){
		return 0;
	}

	error = setTaskTimer(seconds * 1000, 0, handleWake, getCurrentTask(), &timer);
	if (error != NOERR){
		return seconds;
	}

	sleepTask(TASK_SIGNAL_WAIT);

	// Ĥ֤
	remainTime = getRemainTime(timer);

	// 
	freeTimer(timer);

	return remainTime;
}
