/*
 * buf.c
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Хåե
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <machine/interrupt.h>
#include <kern/kmalloc.h>
#include <kern/buf.h>

#include <kern/debug.h>


//#define DEBUG_BUF 1
#ifdef DEBUG_BUF
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//================================== PRIVATE ============================================


//================================== PROTECTED ==========================================


//================================== PUBLIC =============================================

/*
 * ХåեƤ
 * return : EFAULTȡ¥С
 *          ENOMEMƥ꡼ʤ
 */
int allocBuf(
	const uint size, 			// ׵᥵
	ALLOC_BUF *m_allocBuf, 		// ALLOC_BUF¤
	void **o_buf)				// Хåե
{
	uint actualSize;
	int eflag;
	int error = NOERR;

	eflag = enterCli();
	enter_spinlock(&m_allocBuf->lock);
	{
		if (m_allocBuf->sizeTotal < m_allocBuf->sizeMax){
			*o_buf = kmallocSize(size, &actualSize);
			if (*o_buf != NULL){
				m_allocBuf->sizeTotal += actualSize;
			}
			else{
				error = -ENOMEM;
			}
		}
		else{
			error = -EFAULT;	// 祵С
		}
	}
	exit_spinlock(&m_allocBuf->lock);
	exitCli(eflag);
	
	return error;
}

/*
 * ƤХåե
 */
void freeBuf(
	void *i_buf,				// Хåե
	ALLOC_BUF *m_allocBuf)		// ALLOC_BUF¤
{
	int eflag;

	eflag = enterCli();
	enter_spinlock(&m_allocBuf->lock);
	{
		m_allocBuf->sizeTotal -= kfree(i_buf);

		ASSERT(0 <= (int)m_allocBuf->sizeTotal);
	}
	exit_spinlock(&m_allocBuf->lock);
	exitCli(eflag);
}

/*
 * ǽ
 */
int getRestSizeBuf(
	ALLOC_BUF *allocBuf)			// ALLOC_BUF¤
{
	return allocBuf->sizeMax - allocBuf->sizeTotal;
}

/*
 * ALLOC_BUF¤Τ
 */
void initAllocBuf(
	const uint sizeMax, 			// 
	ALLOC_BUF *m_allocBuf)			// ALLOC_BUF¤
{
	memset(m_allocBuf, 0, sizeof(*m_allocBuf));
	m_allocBuf->sizeMax = sizeMax;
}
