/*
 * dev_common.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/conf.h>
#include <kern/device.h>
#include <kern/dev_common.h>

#include <kern/debug.h>


//#define DEBUG_DEV_COMMON 1
#ifdef DEBUG_DEV_COMMON
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern int moduleOpenDev(void *, const int, void**);
extern int moduleCloseDev(void *, void*);
extern int moduleReadDev(void *, void *, const size_t, const size_t, void*);
extern int moduleWriteDev(void *, void *, const size_t, const size_t, void*);
extern int moduleIoctlDev(void *, const int, caddr_t, const int, void*);
extern int modulePollDev(void *, const int, void*);
extern void moduleStatDev(void *, DEV_STAT *);

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * ˥᥸㡼ֹ롣
 * return : ᥸㡼ֹ
 */
int getNewMajor()
{
	static int majorNum = 0;

	return majorNum++;
}

int major(
	const dev_t x)
{
	if (x == NODEV) {
		return NOUDEV;
	}

	return getMajor(x->si_udev);
}

int minor(
	const dev_t x)
{
	if (x == NODEV) {
		return NOUDEV;
	}

	return getMinor(x->si_udev);
}

udev_t makeudev(
	int x, 
	int y)
{
	return ((x << 8) | y);
}

//----------------------------------------------------------
// եե󥯥
//----------------------------------------------------------

int openDev(
	void *m_dev,
	const int i_oflag,
	void **o_privateData)
{
	if (((struct specinfo*) m_dev)->moduleFlag == 0) {
		return devOpenDev(m_dev, i_oflag, o_privateData);
	}
	else {
		return moduleOpenDev(m_dev, i_oflag, o_privateData);
	}
}

int closeDev(
	void *m_dev,
	void *i_privateData)
{
	if (((struct specinfo*) m_dev)->moduleFlag == 0) {
		return devCloseDev(m_dev, i_privateData);
	}
	else {
		return moduleCloseDev(m_dev, i_privateData);
	}
}

int readDev(
	void *i_dev,
	void *m_buf,				// ɤ߹ߥХåե
	const size_t i_bytes,		// ɤ߹ߥХȿ
	const size_t i_offset,
	void *i_privateData)
{
	if (((struct specinfo*) i_dev)->moduleFlag == 0) {
		return devReadDev(i_dev, m_buf, i_bytes, i_offset, i_privateData);
	}
	else {
		return moduleReadDev(i_dev, m_buf, i_bytes, i_offset, i_privateData);
	}
}

int writeDev(
	void *i_dev,
	void *i_buf,				// ɤ߹ߥХåե
	const size_t i_bytes,		// ɤ߹ߥХȿ
	const size_t i_offset,
	void *i_privateData)
{
	if (((struct specinfo*) i_dev)->moduleFlag == 0) {
		return devWriteDev(i_dev, i_buf, i_bytes, i_offset, i_privateData);
	}
	else {
		return moduleWriteDev(i_dev, i_buf, i_bytes, i_offset, i_privateData);
	}
}

int ioctlDev(
	void *i_dev,
	const int cmd,
	caddr_t param,
	const int fflag,
	void *i_privateData)
{
	if (((struct specinfo*) i_dev)->moduleFlag == 0) {
		return devIoctlDev(i_dev, cmd, param, fflag, i_privateData);
	}
	else {
		return moduleIoctlDev(i_dev, cmd, param, fflag, i_privateData);
	}
}

int pollDev(
	void *i_dev,
	const int events,
	void *i_privateData)
{
	if (((struct specinfo*) i_dev)->moduleFlag == 0) {
		return devPollDev(i_dev, events, i_privateData);
	}
	else {
		return modulePollDev(i_dev, events, i_privateData);
	}
}

void statDev(
	void *i_dev,
	DEV_STAT *m_devStat)
{
	if (((struct specinfo*) i_dev)->moduleFlag == 0) {
		devStatDev(i_dev, m_devStat);
	}
	else {
		moduleStatDev(i_dev, m_devStat);
	}
}
