/*
 * dev_method.h
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef dev_method_h
#define dev_method_h


#include <sys/types.h>
#include <sys/bus.h>


#ifndef ASM_FILE


enum{
	device_probe_desc = 1,
	device_attach_desc,
	device_detach_desc,
	device_shutdown_desc,
	device_suspend_desc,
	device_resume_desc,
	device_identify_desc,
	bus_add_child_desc,
	bus_print_child_desc,
	bus_probe_nomatch_desc,
	bus_read_ivar_desc,
	bus_write_ivar_desc,
	bus_child_detached_desc,
	bus_driver_added_desc,
	bus_alloc_resource_desc,
	bus_release_resource_desc,
	bus_setup_intr_desc,
	bus_teardown_intr_desc,
	pci_read_config_desc,
	pci_write_config_desc,
	pci_enable_busmaster_desc,
	pci_disable_busmaster_desc,
	pci_enable_io_desc,
	pci_disable_io_desc,
	miibus_readreg_desc,
	miibus_writereg_desc,
	miibus_statchg_desc,
	miibus_mediainit_desc,
};


extern int				DEVICE_PROBE(device_t);
extern int				DEVICE_ATTACH(device_t);
extern int				DEVICE_DETACH(device_t);
extern int				DEVICE_SHUTDOWN(device_t);
extern int				DEVICE_SUSPEND(device_t);
extern int				DEVICE_RESUME(device_t);
extern void				DEVICE_IDENTIFY(driver_t *, device_t);
extern void				BUS_PROBE_NOMATCH(device_t, device_t);
extern void				BUS_CHILD_DETACHED(device_t, device_t);
extern int				BUS_PRINT_CHILD(device_t, device_t);
extern void				BUS_DRIVER_ADDED(device_t, driver_t *);
extern struct resource*	BUS_ALLOC_RESOURCE(device_t , device_t , int , int *, u_long , u_long , u_long , u_int);
extern int				BUS_RELEASE_RESOURCE(device_t, device_t, int, int, struct resource *);
extern device_t			BUS_ADD_CHILD(device_t, int, const char *, int);
extern int				BUS_READ_IVAR(device_t, device_t, int, uintptr_t *);
extern int				BUS_WRITE_IVAR(device_t, device_t, int, uintptr_t);
extern int				BUS_SETUP_INTR(device_t , device_t , struct resource *, int , void (*handler)(void *), void *, void *);
extern int				BUS_TEARDOWN_INTR(device_t, device_t, struct resource *, void *);
extern u_int32_t		PCI_READ_CONFIG(device_t, device_t, int, int);
extern void				PCI_WRITE_CONFIG(device_t, device_t, int, u_int32_t, int);
extern void				PCI_ENABLE_BUSMASTER(device_t, device_t);
extern void				PCI_DISABLE_BUSMASTER(device_t, device_t);
extern void				PCI_ENABLE_IO(device_t, device_t, int);
extern void				PCI_DISABLE_IO(device_t, device_t, int);
extern int				MIIBUS_READREG(device_t, int, int);
extern int				MIIBUS_WRITEREG(device_t, int, int, int);
extern int				MIIBUS_STATCHG(device_t);
extern int				MIIBUS_MEDIAINIT(device_t);


#endif


#endif
