/*
 * exec.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * եμ¹
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <machine/syscall.h>
#include <kern/fs.h>
#include <kern/Thread.h>
#include <kern/vm.h>
#include <kern/ProcSignal.h>
#include <kern/loader.h>

#include <kern/debug.h>


//#define DEBUG_EXEC 1
#ifdef DEBUG_EXEC
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

//================================== PUBLIC =============================================

/*
 * ĶѿХȿ׻
 * return : Хȿ
 */
int calcArgLen(
	char **argv,	// ץ
	char **envp,	// Ķѿݥ
	int *argc,		// ȥХåե
	int *envc)		// ĶѿȥХåե
{
	int size=0;
	int i;

	for (i = 0; argv[i] != NULL; ++i) {
		size += strlen(argv[i]) + 1;			/*  */
	}
	size += (i + 1) * sizeof(char*);			/* ɥ쥹󥵥 */
	size += sizeof(char**);						/* ɥ쥹ݥ󥿡 */
	*argc = i;

	for (i = 0; envp[i] != NULL; ++i) {
		size += strlen(envp[i]) + 1;			/* Ķѿ */
	}
	size += (i + 1) * sizeof(char*);			/* Ķѿɥ쥹󥵥 */
	size += sizeof(char**);						/* Ķѿɥ쥹ݥ󥿡 */
	*envc = i;

	return ROUNDUP(size + sizeof(int), sizeof(int));		/* +argc. */
}

int sys_exec(
	const char *path, 
	char **argv, 
	char **envp, 
	volatile SYSCALL4_FRAME frame)
{
	uint entryAddr;
	uint stackAddr;
	SYS_INFO *sys_info;
	int error;

	error = loadFile(path, argv, envp, &entryAddr, &stackAddr);
	if (error != NOERR) {
		return error;
	}

	/* å˥ƥꡣ */
	sys_info = (SYS_INFO*)(USER_ESP_BEG - sizeof(SYS_INFO));
	sys_info->lastAddr = getLastLinearAddr();

	/* ʥ륢ν */
	ProcSignalDestructor(procGetProcSignal(getCurrentProc()));
	ProcSignalConstructor(procGetProcSignal(getCurrentProc()));

	/* ե빽¤Τν */
	initExecFs();

/* ƥॳե졼ꡣ */
	frame.eip = entryAddr;
	frame.cs = USER_CODE_DES;
	frame.user_esp = stackAddr - sizeof(frame.para);
	frame.ss = USER_DATA_DES;

	return NOERR;
}
