/*
 * loader.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ¹ԥե
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/fs.h>
#include <kern/elf.h>
#include <kern/shell.h>

#include <kern/debug.h>


//#define DEBUG_LOADER 1
#ifdef DEBUG_LOADER
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

//================================== PROTECTED ==========================================

//================================== PUBLIC =============================================

/*
 * եѥ饿ɥ᥽åɤƤΥ᥽åɤƤӽФ
 * return : error number
 */
int loadFile(
	const char *path,		// ¹ԥեѥ
	char **argv,
	char **envp,
	uint *o_entryAddr,		// åϥ˥ɥ쥹
	uint *o_stackAddr)		// ¹Գϥ˥ɥ쥹
{
	EXEC_FD fd;
	int error;

	error = exec_open(path, &fd);
	if (error != NOERR) {
		return error;
	}

	for (;;) {
		// ELFХʥΥ
		error = loadElf(&fd, argv, envp, o_entryAddr, o_stackAddr);
		if (error != -ENOEXEC) {
			break;
		}

		// SHELLץȤΥ
		error = loadShell(&fd, path, argv, envp, o_entryAddr, o_stackAddr);
		if (error != -ENOEXEC) {
			break;
		}
		
		error = -ENOEXEC;
		break;
	}

	exec_close(&fd);

	return error;
}
