/*
 * proc.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץطإåե
 */


#ifndef proc_h
#define proc_h


#include <sys/types.h>
#include <sys/signal.h>
#include <kern/itimer.h>
#include <kern/vm.h>
#include <kern/ProcSignal.h>
#include <kern/Thread.h>


#ifndef ASM_FILE

#ifdef KERNEL

extern pid_t getPid(const void *);
extern pid_t getPgid(const void *);
extern uid_t getUid(const void *);
extern gid_t getGid(const void *);
extern pid_t getSid(const void *);
extern ITIMER *getItimerVirtual();
extern ITIMER *getItimerProc();
extern VmProcObj *getVmProc(void *);
extern void *getCtltermProc(const void *);
extern ProcSignalObj *procGetProcSignal(const void *);
extern void *getFileStructProc(const void *);
extern ThreadObj *getMainThread(const void*);
extern void setCtltermProc(void *, void *);
extern void procSetExitSignum(void *, const int);
extern void setFileStructProc(void *, void *);
extern void waitProc1();
extern int forkKernelThread();
extern void setInitProc();
extern int createIdleProc(const int);
extern void procSendSignalPgid(const pid_t, const int);
extern void sendSignalAllProc(const int);
extern int procSendSignal(void*, const int);
extern void procForceSendSignal(void*, const int);
extern sigset_t *procGetSignalMask(void*);
extern void procSetSignalMask(void*, const sigset_t*);
extern sigset_t *procGetSignalPending(void*);
extern void procSetSignalPending(void*, const sigset_t*);
extern int procCreatUserHandlerStack(void*);
extern void exit(int,int);
extern void setParentToInit();
extern void *procGetProcPid(const pid_t);
extern void *getCurrentProc();
extern int isBackgroundProc();

extern int sys_fork();
extern int sys_exit();
extern int sys_exec();
extern int sys_wait();
extern int sys_getpid();
extern int sys_getgid();
extern int sys_getpgid();
extern int sys_getppid();
extern int sys_getuid();
extern int sys_getsid();
extern int sys_setgid();
extern int sys_setpgid();
extern int sys_setuid();
extern int sys_setsid();
extern int sys_times();

#endif

#endif

#endif
