/*
 * timer.h
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef timer_h
#define timer_h


#include <sys/AggregateList.h>
#include <sys/time.h>


#ifndef ASM_FILE


/*
 * ޡ¤νͭإå
 */
typedef struct {
	AggregateList	aggregate;	// ޡ󥯽
	int				count;		// 󥯥ޡ
	int				lock;		// ԥå
} TIMER_OWNER;

extern void doRealTimer(const uint);
extern void doIntervalTimer(const uint);
extern int setSystemTimer(const uint, const uint, void (*handle)(void*), void*, void**);
extern int setTaskTimer(const uint, const uint, void (*handle)(void*), void*, void**);
extern void freeTimer(void*);
extern uint getInitTime(void*);
extern uint getRemainTime(void*);
extern int findTimerByHandle(TIMER_OWNER*, void (*handle)(void*), void **);
extern void initTimer();
extern void initProcessTimer(void *);
extern void releaseProcessTimer(TIMER_OWNER*);
extern void micro_timer(uint);
extern void mili_timer(uint);
extern int sys_alarm();


#endif


#endif
