/*
 * vfs.h
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef kern_vfs_h
#define kern_vfs_h


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mount.h>


#ifndef ASM_FILE


/* ե륷ƥ।ե᡼¤ */
typedef struct FS{
	const char *name;
	// parameters : device descriptor, out root inode object
	// retern     : error number
	int (*mount)(void*, void**);
	// parameters : device descriptor, root inode object
	// retern     : error number
	int (*umount)(void*, void*);
	// ѥ˥ܥå󥯥ե뤬Фinode֤
	// parameters : path, device descriptor, directory inode object, out inode number, ܥå̾ݥ
	// retern     : error number or SYMLINK
	int (*lookup)(const char*, void*, void*, uint*, const char**);
	// parameters : path, device descriptor, directory inode object, file type + mode, out inode number
	// retern     : error number
	int (*creat)(const char*, void*, void*, const int, uint*);
	// parameters : device descriptor, inode number, open flag, out inode object, out file type
	// retern     : error number
	int (*open)(void*, const uint, int, void **, int *);
	// parameters : device descriptor, inode object
	// retern     : error number
	int (*close)(void*, void*);
	// parameters : device descriptor, inode object, resd buffer, read bytes, begin byte
	// retern     : read bytes or error number
	int (*read)(void*, void*, void*, size_t, size_t);
	// parameters : device descriptor, inode object, write buffer, write bytes, begin byte
	// retern     : write bytes or error number
	int (*write)(void*, void*, void*, size_t, size_t);
	// parameters : device descriptor, inode object, command, parameter, parameter2, 
	// retern     : error number
	int (*ioctl)(void*, void*, int, caddr_t, int);
	// parameters : inode object, events
	// retern     : poll condition
	int (*poll)(void*, int);
	// parameters : device descriptor, directory inode object, out block, out index 
	// retern     : error number
	int (*opendir)(void*, void*, uint*, int*);
	// parameters : device descriptor, inode object, modify block, modify index, out name 
	// retern     : error number
	int (*readdir)(void*, void*, uint*, int*,char*);
	// parameters : device descriptor, old dir inode object, old path, new dir inode object, new path
	// retern     : error number
	int (*rename)(void*, void*, const char*, void*, const char*);
	// parameters : path, device descriptor, directory inode object, file type + mode, dev number
	// retern     : error number
	int (*mknod)(const char*, void*, void*, const int, const uint);
	// parameters : device descriptor, inode object, modify struct stat
	// retern     : error number
	int (*mkdir)(const char*,void*, void*, int);
	// parameters : device descriptor, inode object, modify struct stat
	// retern     : error number
	int (*stat)(void*, void*, struct stat*);
	// ѥΥǥ쥯ȥꥨȥ꡼inode롣
	//աեѥϿƥǥ쥯ȥ꤬ɬ
	// parameters : path, device descriptor, directory inode object, file type
	// retern     : error number
	int (*delete)(const char*, void*, void*, int);
	// parameters : device descriptor, inode object, mode, uid, gid, access time, modified time
	// retern     : error number
	int (*chattr)(void*, void*, uint, uint, uint, uint, uint);
	// parameters : device descriptor, destination inode object, source inode object, source path
	// retern     : error number
	int (*link)(void*, void*, void*, const char*);
	// parameters : path, device descriptor, directory inode object, link path
	// retern     : error number
	int (*symlink)(const char*, void*, void*, char*);
	// parameters : device descriptor, modify struct statfs
	// retern     : NOERR
	int (*statfs)(void*, struct statfs*);
	struct FS *next;
} FS;


extern int regist_fs(FS*);
extern FS *search_fs(const char *name);
extern int copyRootPath(const void *vent, const size_t size, char *m_path);
extern int mountRoot(const char*,const char*);
extern void umountAllFs();
extern void initVfs();

extern int mountToVfs(FS *, void*, void *, void *);
extern int umountPath(const char *);
extern int creatObj(const char *, const mode_t);
extern int mkdirPath(const char *, const mode_t);
extern int creatSymlink(const char *, const mode_t , char *);
extern int openPath(const char *, const int, void **);
extern int openObj(const char *, const int, void **);
extern int opendirVent(void *, uint *, int *);
extern void linkVent(void *m_vent);
extern void closeVent(void *);
extern void releaseVent(void *);
extern int deleteObj(const char *, const int);
extern int renamePath(const char *, const char *);
extern int readVent(void *i_vent, const size_t size, const size_t offset, void *buf);
extern int writeVent(void *i_vent, const size_t size, const size_t offset, void *buf);
extern int readdirVent(void *, uint *, int *, char *);
extern int statPath(const char *, struct stat *);
extern int statPathSymlink(const char *, struct stat *);
extern int statVent(void *, struct stat *);
extern int statfsPath(const char *, struct statfs *);
extern int searchMount(struct statfs *, const int);
extern int readlinkPath(const char *, const size_t , char *);
extern int chmodPath(const char *, const mode_t);
extern int chmodVent(void *, const mode_t);
extern int chownPath(const char *, const uid_t, const gid_t);
extern int chownVent(void *, const uid_t, const gid_t);
extern int utimesPath(const char *, const struct timeval *);
extern int linkPath(const char *, const char *);
extern int ioctlVent(void *, const int, caddr_t, int);
extern void *getChdirVentPath(const char *, int *);
extern void *getChdirVent(void *, int *);
extern int pollVent(void *, int);
extern int getTypeVent(void *);
extern void *getInodeObjVent(void *);
extern void *getRootEnt();
extern int getTtynameVent(void *, char *);


#endif


#endif
