/*
 * AggregateSingleList.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 * IteratorѥListIteratorꥹ
 *
 *
 * Ǥ¾ϸƤӽФ¦ǤԤȡ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/object.h>
#include <sys/IteratorList.h>
#include <sys/AggregateList.h>

#include <kern/debug.h>


//#define DEBUG_AGGREGATESINGLELIST 1
#ifdef DEBUG_AGGREGATESINGLELIST
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//================================== PRIVATE ============================================

/*
 * ³Ǥμ³
 */
STATIC INLINE void addNext(
	List *dst,
	List *src)
{
	src->next = dst->next;
	dst->next = src;

}

//================================== PUBLIC =============================================

/*
 * ꥹȥإå³
 *³ꥹȥȥ꡼ϽƤ뤳
 */
STATIC void insertHead(
	AggregateList *this,
	List *m_list)
{
	ASSERT(m_list->next == NULL);

	if (this->head == NULL) {
		this->head = m_list;
		this->end = m_list;
	}
	else {
		m_list->next = this->head;
		this->head = m_list;
	}
	this->count += 1;
}

/*
 * ꥹȥɤ³
 *³ꥹȥȥ꡼ϽƤ뤳
 */
STATIC void insertEnd(
	AggregateList *this,
	List *m_list)
{
	ASSERT(m_list->next == NULL);

	if (this->end == NULL) {
		this->head = m_list;
		this->end = m_list;
	}
	else {
		addNext(this->end, m_list);
		this->end = m_list;
	}
	this->count += 1;
}

/*
 * ꥹȥȥ꡼μ³
 */
STATIC void insertNext(
	AggregateList *this,
	List *m_dst,				// ³ȥ꡼
	List *m_src)
{
	// ³ꥹȥȥ꡼ϽƤ뤳
	ASSERT(m_src->next == NULL);

	addNext(m_dst, m_src);
	if (this->end == m_dst) {
		this->end = m_src;
	}
	this->count += 1;
}

/*
 * إåɥȥ꡼Ф
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *getHead(
	AggregateList *this)
{
	if (this->head != NULL) {
		List *headEntry = this->head;
		this->head = headEntry->next;
		
		if (this->end == headEntry) {
			ASSERT(headEntry->next == NULL);

			this->end = NULL;
		}
		headEntry->next = NULL;
		this->count -= 1;

		return headEntry->object;
	}
	else {
		return NULL;
	}
}

/*
 * إåɥȥ꡼򻲾
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refHead(
	AggregateList *this)
{
	if (this->head != NULL) {
		return this->head->object;
	}
	else {
		return NULL;
	}
}

/*
 * ɥȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refEnd(
	AggregateList *this)
{
	if (this->end != NULL) {
		return this->end->object;
	}
	else {
		return NULL;
	}
}

/*
 * Υȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refNext(
	AggregateList *this,
	const List *i_dst)
{
	ASSERT(i_dst != NULL);

	if (i_dst->next != NULL) {
		return i_dst->next->object;
	}
	else {
		return NULL;
	}
}

/*
 * ̤б
 */
STATIC void dummyFunc()
{
	printk("This operation not supported!\n");
	ASSERT(0);
}

//---------------------------- ƥ졼 ------------------------------------

STATIC void iterator(
	AggregateList *this,
	IteratorList *m_iterat)
{
	IteratorListConstruct(m_iterat, this);
}

/*
 * إåɥꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refHeadEntry(
	AggregateList *this)
{
	return this->head;
}

/*
 * Υꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refNextEntry(
	AggregateList *this,
	const List *i_dst)
{
	ASSERT(i_dst != NULL);

	return i_dst->next;
}

/*
 * ꥹ³򻲾
 * return : 
 */
STATIC int getCount(
	AggregateList *this)
{
	return this->count;
}

//---------------------------- 󥹥ȥ饯 ------------------------------------

void AggregateSingleListConstructor(
	AggregateList *this)
{
	// 
	this->head = NULL;
	this->end = NULL;
	this->count = 0;
	this->insertHead = insertHead;
	this->insertEnd = insertEnd;
	this->insertNext = insertNext;
	this->insertPrev = (LIST_FUNC4) dummyFunc;
	this->removeEntry = (LIST_FUNC2) dummyFunc;
	this->getHead = getHead;
	this->getEnd = (LIST_FUNC1) dummyFunc;
//	this->getNext = (LIST_FUNC3) dummyFunc;
//	this->getPrev = (LIST_FUNC3) dummyFunc;
	this->refHead = refHead;
	this->refEnd = refEnd;
	this->refNext = refNext;
	this->refPrev = (LIST_FUNC5) dummyFunc;
	this->pointHeadNext = (LIST_FUNC7) dummyFunc;
	this->removeOut = (LIST_FUNC8) dummyFunc;
	this->iterator = iterator;
	this->iteratorReverce = (LIST_FUNC9) dummyFunc;
	this->refHeadList = refHeadEntry;
	this->refEndList = (LIST_FUNC10) dummyFunc;
	this->refNextList = refNextEntry;
	this->refPrevList = (LIST_FUNC11) dummyFunc;
	this->getCount = getCount;
}
