/*
 * Module.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסե⥸塼
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <sys/AggregateList.h>
#include <lib/lib.h>
#include <machine/io.h>
#include <machine/UserHandler.h>
#include <kern/lock.h>
#include <kern/kmalloc.h>
#include <kern/vm.h>
#include <kern/proc.h>
#include <kern/Thread.h>
#include <kern/Wait.h>
#include <kern/dev_common.h>
#include <module/Module.h>

#include <kern/debug.h>


//#define DEBUG_MODULE 1
#ifdef DEBUG_MODULE
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

typedef struct Module {
	List			list;
	char			name[MODULE_NAME_MAX + 1];
	ThreadObj		*task;
} Module;

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

/*
 * ⥸塼ꥹȽ
 */
static AggregateList moduleAggr;
static int spinLock;

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

STATIC INLINE ThreadObj *getTask(
	Module *this)
{
	return this->task;
}
	
//--------------------------------------------------------------------------------------------------
// Setter
//--------------------------------------------------------------------------------------------------

STATIC INLINE int setName(
	Module *this,
	const char *i_name)
{
	if (snprintf(this->name, MODULE_NAME_MAX, "%s", i_name) <= MODULE_NAME_MAX) {
		return NOERR;
	}
	else {
		return -ENAMETOOLONG;
	}
}

//--------------------------------------------------------------------------------------------------
// Yes or No
//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------
// Search
//--------------------------------------------------------------------------------------------------

STATIC Module *searchTask(
	const ThreadObj *i_task)
{
	Module *module = NULL;
	IteratorList iterator;

	moduleAggr.iterator(&moduleAggr, &iterator);
	enter_spinlock(&spinLock);
	{
		while (iterator.hasNext(&iterator) == BOOL_TRUE) {
			Module *next = iterator.next(&iterator);
			if (next->task == i_task) {
				module = next;
				break;
			}
		}
	}
	exit_spinlock(&spinLock);
	
	return module;
}

STATIC Module *searchName(
	const char *i_name)
{
	Module *module = NULL;
	IteratorList iterator;

	moduleAggr.iterator(&moduleAggr, &iterator);
	enter_spinlock(&spinLock);
	{
		while (iterator.hasNext(&iterator) == BOOL_TRUE) {
			Module *next = iterator.next(&iterator);
			if (strcmp(i_name, next->name) == 0) {
				module = next;
				break;
			}
		}
	}
	exit_spinlock(&spinLock);
	
	return module;
}

//================================== PUBLIC =============================================

void ModuleInit()
{
	AggregateListConstructor(&moduleAggr);
}

void ModuleConstructor(
	Module *this)
{
	listConstructor(&this->list, this);
	this->name[0] = '\0';
	this->task = getCurrentTask();
	enter_spinlock(&spinLock);
	{
		moduleAggr.insertHead(&moduleAggr, &this->list);
	}
	exit_spinlock(&spinLock);
}

void ModuleDestructor(
	Module *this)
{
	enter_spinlock(&spinLock);
	{
		moduleAggr.removeEntry(&moduleAggr, &this->list);
	}
	exit_spinlock(&spinLock);
	kfree(this);
}

//----------------------------------------------------------
// ƥॳ
//----------------------------------------------------------

/*
 * ⥸塼ν
 * return : error number
 */
int sysInitModule()
{
//	if (isBackgroundProc() == NO) {
//		printk("Not background, Execute for background process!\n");
//		return -ENXIO;
//	}

	// 桼⡼ɤɣľܤǤ褦ꤹ
	setUserModeIo();

	return NOERR;
}

/*
 * ⥸塼Ͽ
 * return : error number
 */
int sysRegistModule(
	const char *i_name)		// ⥸塼̾
{
	Module *this;
	int error;

	if (checkMem(i_name, sizeof(MODULE_NAME_MAX + 1)) == ERR) {
		return -EFAULT;
	}

	this = kmalloc(sizeof(*this));
	if (this == NULL) {
		return -ENOMEM;
	}
	ModuleConstructor(this);

	error = setName(this, i_name);

	return error;
}

/*
 * ⥸塼ƤӽФԤ֤ˤ
 * return : error number
 */
int sysSleepModule()
{
	Module *this = searchTask(getCurrentTask());
	if (this == NULL) {
		return -ENOENT;
	}

	// ͥ륹åѹѥץư
	switch (forkKernelThread()) {
	case -1:
		return -ENOBUFS;
	case 0:
		// ƥץinitѤEXIT峫褦ˤ
		setParentToInit();

		// Sleep˥ͥ륹åѹʤ褦֤֤
		wait_task();

		vmSetModuleKernelStack(getVmTask(getTask(this)));
		sys_exit(0);
	}

	// 
	sleepTask(TASK_SIGNAL_WAIT);

	// ⥸塼ǥХ
	ModuleDestructor(this);

	return NOERR;
}

/*
 * ⥸塼
 * return : error number
 */
int sysDeleteModule(
	const char *i_name)		// ⥸塼̾
{
	Module *module;
	ThreadObj *task;

	if (checkMem(i_name, sizeof(MODULE_NAME_MAX + 1)) != NOERR) {
		return -EFAULT;
	}

	module = searchName(i_name);
	if (module == NULL) {
		return -ENOENT;
	}
	task = getTask(module);
	vmResetModuleKernelStack(getVmTask(task));
	wakeTask(getWaitTask(task), TASK_SIGNAL_WAIT);

	return NOERR;
}

//--------------------------------------------------------------------------------------------------
// եե󥯥
//--------------------------------------------------------------------------------------------------

/*
 * ǥХ򥪡ץ󤹤
 * return : error number
 */
int moduleOpenDev(
	Module *m_moduleDev,
	const int i_oflag,
	void **o_privateData)
{
	// ⤷ʤ
	return NOERR;
}

/*
 * ǥХ򥯥
 * return : error number
 */
int moduleCloseDev(
	Module *m_moduleDev,
	void *i_privateData)
{
	// ⤷ʤ
	return NOERR;
}

/*
 * ǥХɤ߹
 * return : read bytes or error number
 */
int moduleReadDev(
	Module *m_moduleDev,
	void *m_buf,			// ߥХåե
	const size_t i_bytes,	// ɤ߹ߥХȿ
	const size_t i_offset,
	void *i_privateData)	// ɤ߹߳ϥХȥեå
{
	// ⤷ʤ
	return NOERR;
}

/*
 * ǥХ˽񤭹
 * return : write bytes or error number
 */
int moduleWriteDev(
	Module *m_moduleDev,
	void *i_buf,			// ɤ߹ߥХåե
	const size_t i_bytes,	// ߥХȿ
	const size_t i_offset,
	void *i_privateData)	// ߳ϥХȥեå
{
	// ⤷ʤ
	return NOERR;
}

/*
 * ǥХIOCTL
 * return : error number
 */
int moduleIoctlDev(
	Module *m_moduleDev,
	const int i_cmd,
	caddr_t i_param,
	const int fflag,
	void *i_privateData)
{
	// ⤷ʤ
	return NOERR;
}

/*
 * ǥХPOLL
 * return : error number
 */
int modulePollDev(
	Module *i_module,
	const int events,
	void *i_privateData)
{
	// ⤷ʤ
	return NOERR;
}

/*
 * ǥХơȤμ
 * return : error number
 */
void moduleStatDev(
	Module *i_module,
	DEV_STAT *m_devStat)
{
	// ⤷ʤ
}
