/*
 * Copyright (c) 1982, 1986, 1988, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)uipc_mbuf.c	8.2 (Berkeley) 1/4/94
 * $FreeBSD: src/sys/kern/uipc_mbuf.c,v 1.51.2.37 2004/06/17 00:08:22 fjoe Exp $
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/mbuf.h>
#include <sys/AggregateList.h>
#include <machine/interrupt.h>
#include <dev/console/console.h>
#include <lib/lib.h>
#include <kern/vm.h>
#include <kern/buf.h>
#include <net/if_var.h>
#include <net/ethernet.h>
#include <net/tcp.h>

#include <kern/debug.h>


//#define DEBUG_MBUF 1
#ifdef DEBUG_MBUF
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE	inline
#endif

//================================== PRIVATE ============================================


enum{
	TRANS_MBUF_MAX	= 0x40000,		// Хåե¥
	RECV_MBUF_MAX	= 0x40000,		// Хåե¥
};

static ALLOC_BUF AllocBufTrans;
static ALLOC_BUF AllocBufRecv;

/*
 * mbufƤ
 * return : struct mbuf or NULLʥ顼
 */
struct mbuf *m_alloc(const uint size, ALLOC_BUF *AllocBuf)
{
	struct mbuf *mbuf;

	if (allocBuf(size + sizeof(*mbuf), AllocBuf, (void**) &mbuf) != NOERR) {
		return NULL;
	}
	memset(mbuf, 0, sizeof(*mbuf));
	mbuf->mh_len = size;
	mbuf->mh_data = (caddr_t) mbuf + sizeof(*mbuf);
	mbuf->allocBuf = AllocBuf;
	listConstructor(&mbuf->list, mbuf);

	return mbuf;
}

//================================== PUBLIC =============================================

/*
 * ХåեƤ
 * return : struct mbuf or NULLʥ顼
 */
struct mbuf *mallocTrans(const uint size)
{
	return m_alloc(size, &AllocBufTrans);
}

/*
 * ХåեƤ
 * return : struct mbuf or NULLʥ顼
 */
struct mbuf *mallocRecv(const uint size)
{
	return m_alloc(size, &AllocBufRecv);
}

/*
 *Գ
 * ХåեƤ
 * return : mbuf or NULL
 */
struct mbuf *m_devget(
	char *fromBuf,			// ԡ
	int size, 				// ԡ
	int off,
	struct ifnet *ifp,
	void (*copy)(char *from, caddr_t to, u_int len))
{
	struct mbuf *mbuf;

	mbuf = m_alloc(size, &AllocBufRecv);
	if (mbuf == NULL){
		return NULL;
	}
	memcpy(mbuf->mh_data + off, fromBuf, size);

	return mbuf;
}

/*
 * MCLBYTESʬΥХåեƤ
 * return : struct mbuf or NULL
 */
struct mbuf *m_getcl(int how, short type, int flags)
{
	return m_alloc(MCLBYTES, &AllocBufRecv);
}

/*
 * ³Хåե
 */
void m_freem(struct mbuf *i_mbuf)
{
	struct mbuf *mbuf;

	for (mbuf = i_mbuf; mbuf != NULL;){
		struct mbuf *next = mbuf->mh_next;
		ASSERT(mbuf->allocBuf != NULL);
		freeBuf(mbuf, mbuf->allocBuf);
		mbuf = next;
	}
}

/*
 * Хåեݥ󥿤ΰư
 */
void m_adj(
	struct mbuf *mbuf,		// оݥХåե
	int off)				// ݥ󥿰ưեå
{
	ASSERT(0 <= mbuf->mh_off + off);

	mbuf->mh_off += off;
}

/*
 * Copy data from a buffer back into the indicated mbuf chain,
 * starting "off" bytes from the beginning, extending the mbuf
 * chain if necessary.
 */
void m_copyback(
	struct	mbuf *mbuf,		// ԡ
	int off,				// ԡ襪եå
	int len,				// ԡ
	caddr_t cp)				// ԡ
{
	ASSERT(off + len <= mbuf->mh_len);
	memcpy(mbuf->mh_data + mbuf->mh_off + off, cp, len);
}

/*
 * mbufǡݥ󥿤
 */
void *getMbufDataPointer(struct mbuf *mbuf)
{
	return mbuf->mh_data + mbuf->mh_off;
}

/*
 * ХåեѤ
 */
void m_recycle(
	struct mbuf *mbuf)		// оݥХåե
{
	ASSERT(mbuf != NULL);

	mbuf->mh_off = 0;
}

void initMbuf()
{
	initAllocBuf(RECV_MBUF_MAX, &AllocBufRecv);
	initAllocBuf(TRANS_MBUF_MAX, &AllocBufTrans);
}


/************************************************************************************
 *
 * Хåե
 *
 ************************************************************************************/

//================================== PRIVATE ============================================

/*
 * ХåեλĤ꤬MCLBYTES꾮
 * return : YES or NO
 */
STATIC INLINE int isFewRecvBuf()
{
	return ((getRestSizeBuf(&AllocBufRecv) - MCLBYTES) < MCLBYTES) ? YES : NO;
}

//================================== PUBLIC =============================================

/*
 * ХåեΤν
 */
void initRecvBuf(
	AggregateList *m_aggregateList)
{
	AggregateListConstructor(m_aggregateList);
}

/*
 * ԤХåեΤIPֹ³
 *ռ߻˸ƤӽФ
 */
void putRecvBuf(
	struct mbuf *m_mbuf,
	AggregateList *m_aggregate,		// ԤХåե
	int *m_lock)					// åȥԥå
{
	int eflag;

	eflag = enterCli();
	enter_spinlock(m_lock);
	{
		IP_HEADER *ip = getMbufDataPointer(m_mbuf);
		IteratorList iterator;

		m_aggregate->iterator(m_aggregate, &iterator);
		for (;;) {
			struct mbuf *nextMbuf;
			IP_HEADER *nextIp;

			if (iterator.hasNext(&iterator) == BOOL_FALSE) {
				m_aggregate->insertEnd(m_aggregate, &m_mbuf->list);
				break;
			}
			
			nextMbuf = iterator.next(&iterator);
			nextIp = getMbufDataPointer(nextMbuf);
			if (swapWord(nextIp->id) < swapWord(ip->id)) {
				m_aggregate->insertPrev(m_aggregate, &nextMbuf->list, &m_mbuf->list);
				break;
			}
		}
	}
	exit_spinlock(m_lock);
	exitCli(eflag);
}

/*
 * ԤХåեTCPΥֹ³
 *ռ߻˸ƤӽФ
 */
void putRecvBufTcp(
	struct mbuf *m_mbuf,
	AggregateList *m_aggregate,	// ԤХåե
	int *m_lock)				// åȥԥå
{
	int eflag;

	eflag = enterCli();
	enter_spinlock(m_lock);
	{
		IP_HEADER *ip = getMbufDataPointer(m_mbuf);
		TCP_HEADER *tcp = (TCP_HEADER*) &ip->data;
		IteratorList iterator;

		m_aggregate->iterator(m_aggregate, &iterator);
		for (;;) {
			struct mbuf *nextMbuf;
			IP_HEADER *nextIp;
			TCP_HEADER *nextTcp;

			if (iterator.hasNext(&iterator) == BOOL_FALSE) {
				m_aggregate->insertEnd(m_aggregate, &m_mbuf->list);
				break;
			}
			
			nextMbuf = iterator.next(&iterator);
			nextIp = getMbufDataPointer(nextMbuf);
			nextTcp = (TCP_HEADER*) &nextIp->data;
			if (swapInt32(nextTcp->seqnum) < swapInt32(tcp->seqnum) || 
				(swapInt32(nextTcp->seqnum) == swapInt32(tcp->seqnum) && swapWord(nextIp->id) < swapWord(ip->id))) {
				m_aggregate->insertPrev(m_aggregate, &nextMbuf->list, &m_mbuf->list);
				break;
			}
		}

		// ХåեλĤݤ뤿ɬפʤ鳫
		if (isFewRecvBuf() == YES) {
			struct mbuf *end = m_aggregate->getHead(m_aggregate);
			if (end != NULL){
				m_freem(end);
			}
		}
	}
	exit_spinlock(m_lock);
	exitCli(eflag);
}

/*
 * ԤХåե󥯤
 */
void detachRecvBuf(
	struct mbuf *m_mbuf,
	AggregateList *m_aggregate,	// ԤХåե
	int *m_lock)				// åȥԥå
{
	int eflag;

	ASSERT(m_mbuf != NULL);

	// 礹"putRecvBuf()"߻˻ѤΤǳ߶ػߡ
	eflag = enterCli();
	enter_spinlock(m_lock);
	{
		m_aggregate->removeEntry(m_aggregate, &m_mbuf->list);
	}
	exit_spinlock(m_lock);
	exitCli(eflag);
}

/*
 * ԤХåեꥹȤФ
 * return : struct mbuf or NULL
 */
struct mbuf *getRecvBuf(
	AggregateList *m_aggregate,	// ԤХåե
	int *m_lock)				// åȥԥå
{
	struct mbuf *mbuf;
	int eflag;

	// 礹"putRecvBuf()"߻˻ѤΤǳ߶ػߡ
	eflag = enterCli();
	enter_spinlock(m_lock);
	{
		mbuf = m_aggregate->getEnd(m_aggregate);
	}
	exit_spinlock(m_lock);
	exitCli(eflag);

	return mbuf;
}

/*
 * ԤХåեꥹȤ鼡ΥХåե򻲾Ȥ
 * return : struct mbuf ro NULL
 */
struct mbuf *refRecvBuf(
	AggregateList *i_aggregate)	// ԤХåե
{
	return i_aggregate->refEnd(i_aggregate);
}

/*
 * ХåեꥹȤγ
 */
void releaseRecvBuf(
	AggregateList *m_aggregate)		// ԤХåե
{
	struct mbuf *mbuf;

	while ((mbuf = m_aggregate->getHead(m_aggregate)) != NULL) {
		m_freem(mbuf);
	}
}

//*************************************************************************************************

void test_mbuf(uint pointa, uint callFrom)
{
}
