/*
 * Copyright (c) 1982, 1986, 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)mbuf.h	8.5 (Berkeley) 2/19/95
 * $FreeBSD: src/sys/sys/mbuf.h,v 1.44.2.26 2004/06/17 00:08:21 fjoe Exp $
 */


#ifndef _SYS_MBUF_H_
#define	_SYS_MBUF_H_


#include <sys/types.h>
#include <sys/queue.h>
#include <sys/select.h>
#include <sys/AggregateList.h>
#include <net/net.h>
#include <net/if_var.h>

#include <kern/debug.h>


struct ifnet;


/*
 * Mbufs are of a single size, MSIZE (machine/param.h), which
 * includes overhead.  An mbuf may add a single "mbuf cluster" of size
 * MCLBYTES (also in machine/param.h), which has no additional overhead
 * and is used instead of the internal data area; this is done when
 * at least MINCLSIZE of data must be stored.
 */
#define MSIZE		0x10000		// Ȥꤢ
#define	MLEN		MSIZE
#define	MHLEN		MLEN - sizeof(struct pkthdr)

/*
 * mtod(m, t)	-- Convert mbuf pointer to data pointer of correct type.
 */
#define	mtod(m, t)	((t)getMbufDataPointer(m))


// Record/packet header in first mbuf of chain; valid only if M_PKTHDR is set.
struct pkthdr {
	int		len;				/* ѥåȡ˥ */
};

/*
 * Header present at the beginning of every mbuf.
 */
struct m_hdr {
	int				mh_len;		/* amount of data in this mbuf */
	short			mh_type;	/* type of data in this mbuf */
	short			mh_flags;	/* flags; see below */
	int				off;		// ǡեå
	int				offset;		/* 桼ѥեå */
	SOCKET			*sock;		// å
	caddr_t			mh_data;	//աmh_dataΥϲѤʤΤǹ֤ܰϺǸ֤
};

// ǡϥǥХؤΥץȥˤƤ
// ˥ͥåȤʤ饤ͥåȥǡեޥå
struct mbuf {
	List			list;
	struct mbuf		*mh_next;
	struct pkthdr	MH_pkthdr;		/* M_PKTHDR set */
	void			*allocBuf;		// ALLOC_BUFɥ쥹
	struct m_hdr	m_hdr;			//աmh_dataΥϲѤʤΤǹ֤ܰϺǸ֤
};
#define	mh_len		m_hdr.mh_len
#define	mh_data		m_hdr.mh_data
#define	mh_type		m_hdr.mh_type
#define	mh_flags	m_hdr.mh_flags
#define	mh_pkthdr	MH_pkthdr
#define	mh_off		m_hdr.off
#define	mh_offset	m_hdr.offset
#define	mh_sock		m_hdr.sock
#define	mh_access	m_hdr.access

/*
 * Flags specifying how an allocation should be made.
 */
#define	M_DONTWAIT	1
#define	M_WAIT		0

/*
 * mbuf types.
 */
#define	MT_FREE		0	/* should be on free list */
#define	MT_DATA		1	/* dynamic (data) allocation */
#define	MT_HEADER	2	/* packet header */
#if 0
#define	MT_SOCKET	3	/* socket structure */
#define	MT_PCB		4	/* protocol control block */
#define	MT_RTABLE	5	/* routing tables */
#define	MT_HTABLE	6	/* IMP host tables */
#define	MT_ATABLE	7	/* address resolution tables */
#endif
#define	MT_SONAME	8	/* socket name */
#if 0
#define	MT_SOOPTS	10	/* socket options */
#endif
#define	MT_FTABLE	11	/* fragment reassembly header */
#if 0
#define	MT_RIGHTS	12	/* access rights */
#define	MT_IFADDR	13	/* interface address */
#endif
#define	MT_TAG		13	/* volatile metadata associated to pkts */
#define	MT_CONTROL	14	/* extra-data protocol message */
#define	MT_OOBDATA	15	/* expedited data  */
#define	MT_NTYPES	16	/* number of mbuf types for mbtypes[] */

/*
 * mbuf flags.
 */
#define	M_EXT		0x0001	/* has associated external storage */
#define	M_PKTHDR	0x0002	/* start of record */
#define	M_EOR		0x0004	/* end of record */
#define	M_PROTO1	0x0008	/* protocol-specific */
#define	M_PROTO2	0x0010	/* protocol-specific */
#define	M_PROTO3	0x0020	/* protocol-specific */
#define	M_PROTO4	0x0040	/* protocol-specific */
#define	M_PROTO5	0x0080	/* protocol-specific */


extern struct mbuf	*mallocTrans(const uint);
extern struct mbuf	*mallocRecv(const uint);
extern struct mbuf	*m_devget(char *, int, int, struct ifnet *, void (*copy)(char *, caddr_t, u_int));
extern struct mbuf	*m_getcl(int how, short type, int flags);
extern void			m_freem(struct mbuf *);
extern void			mgethdr(struct mbuf **);
extern void			m_adj(struct mbuf *, int);
extern void			m_copyback(struct mbuf *, int, int, caddr_t);
extern void			m_copydata(struct mbuf *, int, int, caddr_t);
extern void			m_recycle(struct mbuf *);

extern void			initMbuf();
extern void			*getMbufDataPointer(struct mbuf *);
extern void			initRecvBuf(AggregateList *);
extern void			putRecvBuf(struct mbuf*, AggregateList *, int*);
extern void			putRecvBufTcp(struct mbuf*, AggregateList *, int*);
extern struct mbuf	*refRecvBuf(AggregateList *);
extern void			detachRecvBuf(struct mbuf*, AggregateList *, int*);
extern struct mbuf	*getRecvBuf(AggregateList *, int*);
extern void			releaseRecvBuf(AggregateList *);
extern int			isNoRecvBuf();


#endif /* !_SYS_MBUF_H_ */
