/*
 * sys/select.h
 */


#ifndef sys_select_h
#define sys_select_h


#include <sys/types.h>
#include <sys/limits.h>
#include <sys/time.h>


#ifndef ASM_FILE


enum{
	FD_SETSIZE = _POSIX_OPEN_MAX,			/* Maximum number of file descriptors in an fd_set structure. */
	FD_BITMAP_LEN = FD_SETSIZE / CHAR_BIT + 1
};

#define FD_CLR(fdNum, fdset)	((fdset)->bitmap[fdNum / CHAR_BIT] &= ~(char)(1 << (fdNum % CHAR_BIT)))
#define FD_ISSET(fdNum, fdset)	((fdset)->bitmap[fdNum / CHAR_BIT] & (char)(1 << (fdNum % CHAR_BIT)))
#define FD_SET(fdNum, fdset)	((fdset)->bitmap[fdNum / CHAR_BIT] |= (char)(1 << (fdNum % CHAR_BIT)))
#define FD_ZERO(fdset)			memset((fdset)->bitmap, 0, FD_BITMAP_LEN)


typedef struct fd_set{
	char bitmap[FD_BITMAP_LEN];
}fd_set;


/*
 * Used to maintain information about processes that wish to be
 * notified when I/O becomes possible.
 */
struct selinfo {
	pid_t			si_pid;		/* process to be notified */
/*	struct klist	si_note;*/	/* kernel note list */
	short			si_flags;	/* see below */
};
#define	SI_COLL	0x0001		/* collision occurred */


#ifndef KERNEL


extern int select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *errorfds, struct timeval *timeout);


#endif


#endif


#endif
