/*
 * stat.h
 */


#ifndef sys_stat_h
#define sys_stat_h


#include<sys/types.h>
#include<sys/time.h>


#ifdef KERNEL
#define __dev_t	udev_t
#else
#define __dev_t	dev_t
#endif


#ifndef ASM_FILE


#define S_ISUID		0x0800		/* Set-user-ID on execution. */
#define S_ISGID		0x0400		/* Set-group-ID on execution. */
#define S_IRWXU		0x01C0		/* Read, write, execute/search by owner. */
#define S_IRUSR		0x0100		/* Read permission, owner. */
#define S_IWUSR		0x0080		/* Write permission, owner. */
#define S_IXUSR		0x0040		/* Execute/search permission, owner. */
#define S_IRWXG		0x0038		/* Read, write, execute/search by group. */
#define S_IRGRP		0x0020		/* Read permission, group. */
#define S_IWGRP		0x0010		/* Write permission, group. */
#define S_IXGRP		0x0008		/* Execute/search permission, group. */
#define S_IRWXO		0x0007		/* Read, write, execute/search by others. */
#define S_IROTH		0x0004		/* Read permission, others. */
#define S_IWOTH		0x0002		/* Write permission, others. */
#define S_IXOTH		0x0001		/* Execute/search permission, others. */

#define S_ISVTX		0x200		/* save swapped text even after use */
#define S_ISTXT		0x200		/* sticky bit */

/* File types. */
#define S_IFMT		0xF000		/* format mask */
#define S_IFIFO		0x1000		/* fifo */
#define S_IFCHR		0x2000		/* character device */
#define S_IFDIR		0x4000		/* directory */
#define S_IFBLK		0x6000		/* block device */
#define S_IFREG		0x8000		/* regular file */
#define S_IFLNK		0xA000		/* symbolic link */
#define S_IFSOCK	0xC000		/* socket */
#define S_IFMDL		0xD000		/* module device */
#define S_IFWHT		0xE000		/* whiteout */

#define ALLPERMS	(S_ISUID|S_ISGID|S_ISTXT|S_IRWXU|S_IRWXG|S_IRWXO)
#define DEFFILEMODE	(S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH)
#define S_IRUGO		(S_IRUSR|S_IRGRP|S_IROTH)


/* The macro shall evaluate to a non-zero value if the test is true; 0 if the test is false. */
#define S_ISFIFO(m) ((m&S_IFIFO)==S_IFIFO)		/* Test for a pipe or FIFO special file. */
#define S_ISCHR(m)  ((m&S_IFCHR)==S_IFCHR)		/* Test for a character special file. */
#define S_ISDIR(m)  ((m&S_IFDIR)==S_IFDIR)		/* Test for a directory. */
#define S_ISBLK(m)  ((m&S_IFBLK)==S_IFBLK)		/* Test for a block special file. */
#define S_ISREG(m)  ((m&S_IFREG)==S_IFREG)		/* Test for a regular file. */
#define S_ISLNK(m)  ((m&S_IFLNK)==S_IFLNK)		/* Test for a symbolic link. */
#define S_ISSOCK(m) ((m&S_IFSOCK)==S_IFSOCK)	/* Test for a socket. */
#define	S_ISWHT(m)	((m&S_IFWHT)==S_IFWHT)		/* whiteout. */

/*
 * The implementation may implement message queues, semaphores, or shared memory objects as distinct
 * file types. The following macros shall be provided to test whether a file is of the specified type.
 * The value of the buf argument supplied to the macros is a pointer to a stat structure. The macro
 * shall evaluate to a non-zero value if the specified object is implemented as a distinct file type
 * and the specified file type is contained in the stat structure referenced by buf. Otherwise,
 * the macro shall evaluate to zero.
 */
#define S_TYPEISMQ(buf)			/* Test for a message queue. */
#define S_TYPEISSEM(buf)		/* Test for a semaphore. */
#define S_TYPEISSHM(buf)		/* Test for a shared memory object. */

/*
 * Definitions of flags stored in file flags word.
 *
 * Super-user and owner changeable flags.
 */
#define	UF_SETTABLE		0x0000ffff	/* mask of owner changeable flags */
#define	UF_NODUMP		0x00000001	/* do not dump file */
#define	UF_IMMUTABLE	0x00000002	/* file may not be changed */
#define	UF_APPEND		0x00000004	/* writes to file may only append */
#define UF_NOUNLINK		0x00000010	/* file may not be removed or renamed */
#define UF_OPAQUE		0x00000008	/* directory is opaque wrt. union */
/*
 * Super-user changeable flags.
 */
#define	SF_SETTABLE		0xffff0000	/* mask of superuser changeable flags */
#define	SF_ARCHIVED		0x00010000	/* file is archived */
#define	SF_IMMUTABLE	0x00020000	/* file may not be changed */
#define	SF_APPEND		0x00040000	/* writes to file may only append */
#define	SF_NOUNLINK		0x00100000	/* file may not be removed or renamed */


/* The stat structure. */
struct stat{
	__dev_t		st_dev;		/* Device ID of device containing file. */
	ino_t		st_ino;		/* File serial number. */
	mode_t		st_mode;	/* Mode of file. */
	nlink_t		st_nlink;	/* Number of hard links to the file. */
	uid_t		st_uid;		/* User ID of file. */
	gid_t		st_gid;		/* Group ID of file. */
	off_t		st_size;	/* For regular files, the file size in bytes. */
	time_t		st_atime;	/* Time of last access. */
	time_t		st_mtime;	/* Time of last data modification. */
	time_t		st_ctime;	/* Time of last status change. */
	size_t		st_crtpos;	/* option,current file position. */
	uint32_t	st_blksize;	/* optimal blocksize for I/O */
	__dev_t		st_rdev;	/* device type */
	uint32_t	st_flags;	/* user defined flags for file */
	int64_t		st_blocks;	/* blocks allocated for file */
	/* POSIX4. */
	struct	timespec st_atimespec;	/* time of last access */
	struct	timespec st_mtimespec;	/* time of last data modification */
	struct	timespec st_ctimespec;	/* time of last file status change */
};


#ifndef KERNEL	

/* functions and may also be defined as macros. */
extern int	  chflags (const char *, u_long);
extern int    chmod(const char*, mode_t);
extern int	  fchflags (int, u_long);
extern int    fchmod(int, mode_t);
extern int    fstat(int, struct stat*);
extern int    lchmod(const char*, mode_t);
extern int    lstat(const char *, struct stat *);
extern int    mkdir(const char*, mode_t);
extern int    mkfifo(const char*, mode_t);
extern int    mknod(const char *, mode_t, __dev_t);
extern int    stat(const char*, struct stat*);
extern mode_t umask(mode_t);

extern int openMask;	/* եεĥӥåȥޥ */

#endif


#endif


#endif
