/*
 * sys/systm.h
 */


#ifndef sys_systm_h
#define sys_systm_h


#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/callout.h>
#include <sys/proc.h>
#include <lib/lib.h>
#include <kern/lock.h>
#include <machine/stdarg.h>


#ifdef KERNEL


struct callout_handle;


typedef void timeout_t __P((void *));	/* timeout function type */


#define bootverbose 0		/* nonzero to print verbose messages */

#define uprintf printf
#define bzero(buf, len) memset(buf, 0, len)
#define splhigh enterCli
#define splbio enterCli

extern inline int copyin __P((const void *udaddr, void *kaddr, size_t len))
{
	memcpy(kaddr, udaddr, len);
	return 0;
}
extern inline int copyout __P((const void *kaddr, void *udaddr, size_t len))
{
	memcpy(udaddr, kaddr, len);
	return 0;
}
extern inline intrmask_t	splimp __P((void))
{
	// Ȃ
	return 0;
}
extern inline intrmask_t	spltty __P((void))
{
	// Ȃ
	return 0;
}
extern inline void splx __P((intrmask_t ipl))
{
	// Ȃ
}


extern void	bcopy __P((const void *from, void *to, size_t len));
extern int	seltrue __P((dev_t dev, int which, struct proc *p));
extern int	printf __P((const char *, ...));
extern int	vprintf __P((const char *, va_list));
extern int	kvprintf __P((char const *, void (*)(int, void*), void *, int, va_list));
extern int	snprintf __P((char *, size_t, const char *, ...));
extern int	sprintf __P((char *buf, const char *, ...));
extern struct	callout_handle timeout __P((timeout_t *, void *, int));
extern void	untimeout __P((timeout_t *, void *, struct callout_handle));
extern void	callout_handle_init __P((struct callout_handle *));
extern int	tsleep __P((void *chan, int pri, const char *wmesg, int timo));
extern void	wakeup __P((void *chan));


#endif


#endif
