/*
 * sys/time.h
 */


#ifndef sys_time_h
#define sys_time_h


#include<sys/cdefs.h>
#include<sys/types.h>


#ifndef ASM_FILE


enum {
	// ΥǥåǻѤΤITIMER_VIRTUAL = 0,ITIMER_PROF = 1Ǹ
	ITIMER_VIRTUAL =	0,
	ITIMER_PROF =		1,
	ITIMER_REAL =		2,
};

struct timeval {
	long	tv_sec;		/* seconds */
	long	tv_usec;	/* and microseconds */
};

struct itimerval {
    struct  timeval it_interval;    /* timer interval */
    struct  timeval it_value;   	/* current value */
};

struct timezone {
    int tz_minuteswest; /* minutes west of Greenwich */
    int tz_dsttime; 	/* type of dst correction */
};

/*
 * Structure defined by POSIX.4 to be like a timeval.
 */
struct timespec {
	time_t	tv_sec;		/* seconds */
	long	tv_nsec;	/* and nanoseconds */
};


/* ץ */
#define	TIMEVAL_TO_TIMESPEC(tv, ts) {				\
	(ts)->tv_sec = (tv)->tv_sec;					\
	(ts)->tv_nsec = (tv)->tv_usec * 1000;			\
}
#define	TIMESPEC_TO_TIMEVAL(tv, ts) {				\
	(tv)->tv_sec = (ts)->tv_sec;					\
	(tv)->tv_usec = (ts)->tv_nsec / 1000;			\
}

#define	timerclear(tvp)		(tvp)->tv_sec = (tvp)->tv_usec = 0
#define	timerisset(tvp)		((tvp)->tv_sec || (tvp)->tv_usec)
#define	timercmp(tvp, uvp, cmp)						\
	(((tvp)->tv_sec == (uvp)->tv_sec) ?				\
	    ((tvp)->tv_usec cmp (uvp)->tv_usec) :		\
	    ((tvp)->tv_sec cmp (uvp)->tv_sec))
#define timeradd(tvp, uvp, vvp)						\
	do {								\
		(vvp)->tv_sec = (tvp)->tv_sec + (uvp)->tv_sec;		\
		(vvp)->tv_usec = (tvp)->tv_usec + (uvp)->tv_usec;	\
		if ((vvp)->tv_usec >= 1000000) {			\
			(vvp)->tv_sec++;				\
			(vvp)->tv_usec -= 1000000;			\
		}							\
	} while (0)
#define timersub(tvp, uvp, vvp)						\
	do {								\
		(vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;		\
		(vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;	\
		if ((vvp)->tv_usec < 0) {				\
			(vvp)->tv_sec--;				\
			(vvp)->tv_usec += 1000000;			\
		}							\
	} while (0)

#ifdef KERNEL

/*
 * struct timeval ms֤
 * return : mili seconds
 */
static inline uint getMiliSecondsTimeval(
	const struct timeval *i_timeval)
{
	int miliSeconds;

	miliSeconds = i_timeval->tv_sec * 1000;
	miliSeconds += i_timeval->tv_usec / 1000;
	
	return miliSeconds;
}

/*
 * ms֤struct timeval򥻥åȤ
 */
static inline void setTimevalMiliSeconds(
	const uint i_miliSeconds,
	struct timeval *m_timeval)
{
	m_timeval->tv_sec = i_miliSeconds / 1000;
	m_timeval->tv_usec = (i_miliSeconds % 1000) * 1000;
}

#define getmicrotime gettimeofday

extern void	getmicrouptime __P((struct timeval *tv));
extern void	microtime __P((struct timeval *tv));
extern void	timevaladd __P((struct timeval *, struct timeval *));
extern void	timevalsub __P((struct timeval *, struct timeval *));
extern time_t	time_second();

#else

extern int utimes(const char *path, const struct timeval *times);
extern int lutimes(const char *path, const struct timeval *times);
extern int gettimeofday(struct timeval *tv, struct timezone *tz);
extern int settimeofday(struct timeval *tp, const struct timezone *tzp);
extern int getitimer (int, struct itimerval *);
extern int setitimer (int, const struct itimerval *, struct itimerval *);
extern int calcMicroSeconds(int);

#endif


#endif


#endif
